/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.support.cursor;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.support.cursor.CursorFilter;
import com.cz.widget.recyclerview.adapter.support.cursor.CursorFilterClient;

public abstract class CursorRecyclerAdapter<H extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<H>
implements Filterable,
CursorFilterClient {
    private static final String TAG = "CursorRecyclerAdapter";
    protected boolean mDataValid;
    protected boolean mAutoRequery;
    protected Cursor mCursor;
    protected Context mContext;
    protected int mRowIDColumn;
    protected ChangeObserver mChangeObserver;
    protected DataSetObserver mDataSetObserver;
    protected CursorFilter mCursorFilter;
    protected FilterQueryProvider mFilterQueryProvider;
    protected final LayoutInflater mInflater;
    @Deprecated
    public static final int FLAG_AUTO_REQUERY = 1;
    public static final int FLAG_REGISTER_CONTENT_OBSERVER = 2;

    public CursorRecyclerAdapter(Context context, Cursor c) {
        this(context, c, 2);
    }

    public CursorRecyclerAdapter(Context context, Cursor c, int flags) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.init(context, c, flags);
    }

    void init(Context context, Cursor c, int flags) {
        if ((flags & 1) == 1) {
            flags |= 2;
            this.mAutoRequery = true;
        } else {
            this.mAutoRequery = false;
        }
        boolean cursorPresent = c != null;
        this.mCursor = c;
        this.mDataValid = cursorPresent;
        this.mContext = context;
        int n = this.mRowIDColumn = cursorPresent ? c.getColumnIndexOrThrow("_id") : -1;
        if ((flags & 2) == 2) {
            this.mChangeObserver = new ChangeObserver();
            this.mDataSetObserver = new MyDataSetObserver();
        } else {
            this.mChangeObserver = null;
            this.mDataSetObserver = null;
        }
        if (cursorPresent) {
            if (this.mChangeObserver != null) {
                c.registerContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                c.registerDataSetObserver(this.mDataSetObserver);
            }
        }
    }

    protected View inflateView(ViewGroup parent, int layout) {
        return this.mInflater.inflate(layout, parent, false);
    }

    @Override
    public Cursor getCursor() {
        return this.mCursor;
    }

    public Cursor getCursor(int position) {
        this.mCursor.moveToPosition(position);
        return this.mCursor;
    }

    public Object getItem(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    public long getItemId(int position) {
        if (this.mDataValid && this.mCursor != null) {
            if (this.mCursor.moveToPosition(position)) {
                return this.mCursor.getLong(this.mRowIDColumn);
            }
            return 0L;
        }
        return 0L;
    }

    public void onBindViewHolder(H holder, int position) {
        if (!this.mDataValid) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("couldn't move cursor to position " + position);
        }
        this.onBindViewHolder(holder, this.mCursor, position);
    }

    public abstract void onBindViewHolder(H var1, Cursor var2, int var3);

    public int getItemCount() {
        int itemCount = 0;
        if (this.mDataValid && this.mCursor != null) {
            itemCount = this.mCursor.getCount();
        }
        return itemCount;
    }

    public abstract H onCreateViewHolder(ViewGroup var1, int var2);

    @Override
    public void changeCursor(@Nullable Cursor cursor) {
        Cursor old = this.swapCursor(cursor);
        if (old != null) {
            old.close();
        }
    }

    public Cursor swapCursor(@Nullable Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return null;
        }
        Cursor oldCursor = this.mCursor;
        if (oldCursor != null) {
            if (this.mChangeObserver != null) {
                oldCursor.unregisterContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                oldCursor.unregisterDataSetObserver(this.mDataSetObserver);
            }
        }
        this.mCursor = newCursor;
        if (newCursor != null) {
            if (this.mChangeObserver != null) {
                newCursor.registerContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                newCursor.registerDataSetObserver(this.mDataSetObserver);
            }
            this.mRowIDColumn = newCursor.getColumnIndexOrThrow("_id");
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            this.notifyDataSetChanged();
        }
        return oldCursor;
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mCursor;
    }

    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    protected void onContentChanged() {
        Log.e((String)TAG, (String)"onContentChanged");
        if (this.mAutoRequery && this.mCursor != null && !this.mCursor.isClosed()) {
            Log.e((String)TAG, (String)"onCursorReQuery");
            this.mDataValid = this.mCursor.requery();
        }
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        public void onChanged() {
            CursorRecyclerAdapter.this.mDataValid = true;
            CursorRecyclerAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            CursorRecyclerAdapter.this.mDataValid = false;
            CursorRecyclerAdapter.this.notifyDataSetChanged();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            CursorRecyclerAdapter.this.onContentChanged();
        }
    }
}

