/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.spring;

import java.util.Map;
import org.springframework.ai.mcp.client.McpSyncClient;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;

public class McpFunctionCallback
implements FunctionCallback {
    private final McpSyncClient mcpClient;
    private final McpSchema.Tool tool;

    public McpFunctionCallback(McpSyncClient clientSession, McpSchema.Tool tool) {
        this.mcpClient = clientSession;
        this.tool = tool;
    }

    public String getName() {
        return this.tool.name();
    }

    public String getDescription() {
        return this.tool.description();
    }

    public String getInputTypeSchema() {
        return ModelOptionsUtils.toJsonString((Object)this.tool.inputSchema());
    }

    public String call(String functionInput) {
        Map arguments = ModelOptionsUtils.jsonToMap((String)functionInput);
        McpSchema.CallToolResult response = this.mcpClient.callTool(new McpSchema.CallToolRequest(this.getName(), arguments));
        return ModelOptionsUtils.toJsonString((Object)response.content());
    }
}

