/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.ai.mcp.client.McpClient;
import org.springframework.ai.mcp.client.McpSyncClient;
import org.springframework.ai.mcp.spec.ClientMcpTransport;
import org.springframework.ai.mcp.spec.McpSchema;

public abstract class AbstractMcpSyncClientTests {
    private McpSyncClient mcpSyncClient;
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final String TEST_MESSAGE = "Hello MCP Spring AI!";
    protected ClientMcpTransport mcpTransport;

    protected abstract ClientMcpTransport createMcpTransport();

    protected abstract void onStart();

    protected abstract void onClose();

    @BeforeEach
    void setUp() {
        this.onStart();
        this.mcpTransport = this.createMcpTransport();
        Assertions.assertThatCode(() -> {
            this.mcpSyncClient = McpClient.sync((ClientMcpTransport)this.mcpTransport).requestTimeout(TIMEOUT).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build()).build();
            this.mcpSyncClient.initialize();
        }).doesNotThrowAnyException();
    }

    @AfterEach
    void tearDown() {
        if (this.mcpSyncClient != null) {
            Assertions.assertThatCode(() -> this.mcpSyncClient.close()).doesNotThrowAnyException();
        }
        this.onClose();
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync((ClientMcpTransport)this.mcpTransport).requestTimeout(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Request timeout must not be null");
    }

    @Test
    void testListTools() {
        McpSchema.ListToolsResult tools = this.mcpSyncClient.listTools(null);
        ((ObjectAssert)Assertions.assertThat((Object)tools).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
            McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
            Assertions.assertThat((String)firstTool.name()).isNotNull();
            Assertions.assertThat((String)firstTool.description()).isNotNull();
        }});
    }

    @Test
    void testCallTools() {
        McpSchema.CallToolResult toolResult = this.mcpSyncClient.callTool(new McpSchema.CallToolRequest("add", Map.of("a", 3, "b", 4)));
        ((ObjectAssert)Assertions.assertThat((Object)toolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.content()).hasSize(1);
            McpSchema.TextContent content = (McpSchema.TextContent)result.content().get(0);
            Assertions.assertThat((Object)content).isNotNull();
            Assertions.assertThat((String)content.text()).isNotNull();
            Assertions.assertThat((String)content.text()).contains(new CharSequence[]{"7"});
        }});
    }

    @Test
    void testPing() {
        Assertions.assertThatCode(() -> this.mcpSyncClient.ping()).doesNotThrowAnyException();
    }

    @Test
    void testCallTool() {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", TEST_MESSAGE));
        McpSchema.CallToolResult callToolResult = this.mcpSyncClient.callTool(callToolRequest);
        ((ObjectAssert)Assertions.assertThat((Object)callToolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.content()).isNotNull();
            Assertions.assertThat((Boolean)result.isError()).isNull();
        }});
    }

    @Test
    void testCallToolWithInvalidTool() {
        McpSchema.CallToolRequest invalidRequest = new McpSchema.CallToolRequest("nonexistent_tool", Map.of("message", TEST_MESSAGE));
        Assertions.assertThatThrownBy(() -> this.mcpSyncClient.callTool(invalidRequest)).isInstanceOf(Exception.class);
    }

    @Test
    void testRootsListChanged() {
        Assertions.assertThatCode(() -> this.mcpSyncClient.rootsListChangedNotification()).doesNotThrowAnyException();
    }

    @Test
    void testListResources() {
        McpSchema.ListResourcesResult resources = this.mcpSyncClient.listResources(null);
        ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.resources()).isNotNull();
            if (!result.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                Assertions.assertThat((String)firstResource.uri()).isNotNull();
                Assertions.assertThat((String)firstResource.name()).isNotNull();
            }
        }});
    }

    @Test
    void testClientSessionState() {
        Assertions.assertThat((Object)this.mcpSyncClient).isNotNull();
    }

    @Test
    void testInitializeWithRootsListProviders() {
        ClientMcpTransport transport = this.createMcpTransport();
        McpSyncClient client = McpClient.sync((ClientMcpTransport)transport).requestTimeout(TIMEOUT).roots(new McpSchema.Root[]{new McpSchema.Root("file:///test/path", "test-root")}).build();
        Assertions.assertThatCode(() -> {
            client.initialize();
            client.close();
        }).doesNotThrowAnyException();
    }

    @Test
    void testAddRoot() {
        McpSchema.Root newRoot = new McpSchema.Root("file:///new/test/path", "new-test-root");
        Assertions.assertThatCode(() -> this.mcpSyncClient.addRoot(newRoot)).doesNotThrowAnyException();
    }

    @Test
    void testAddRootWithNullValue() {
        Assertions.assertThatThrownBy(() -> this.mcpSyncClient.addRoot(null)).hasMessageContaining("Root must not be null");
    }

    @Test
    void testRemoveRoot() {
        McpSchema.Root root = new McpSchema.Root("file:///test/path/to/remove", "root-to-remove");
        Assertions.assertThatCode(() -> {
            this.mcpSyncClient.addRoot(root);
            this.mcpSyncClient.removeRoot(root.uri());
        }).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonExistentRoot() {
        Assertions.assertThatThrownBy(() -> this.mcpSyncClient.removeRoot("nonexistent-uri")).hasMessageContaining("Root with uri 'nonexistent-uri' not found");
    }

    @Test
    void testReadResource() {
        McpSchema.ListResourcesResult resources = this.mcpSyncClient.listResources(null);
        if (!resources.resources().isEmpty()) {
            McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
            McpSchema.ReadResourceResult result = this.mcpSyncClient.readResource(firstResource);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.contents()).isNotNull();
        }
    }

    @Test
    void testListResourceTemplates() {
        McpSchema.ListResourceTemplatesResult result = this.mcpSyncClient.listResourceTemplates(null);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
    }

    void testResourceSubscription() {
        McpSchema.ListResourcesResult resources = this.mcpSyncClient.listResources(null);
        if (!resources.resources().isEmpty()) {
            McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
            Assertions.assertThatCode(() -> this.mcpSyncClient.subscribeResource(new McpSchema.SubscribeRequest(firstResource.uri()))).doesNotThrowAnyException();
            Assertions.assertThatCode(() -> this.mcpSyncClient.unsubscribeResource(new McpSchema.UnsubscribeRequest(firstResource.uri()))).doesNotThrowAnyException();
        }
    }

    @Test
    void testNotificationHandlers() {
        AtomicBoolean toolsNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean resourcesNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean promptsNotificationReceived = new AtomicBoolean(false);
        ClientMcpTransport transport = this.createMcpTransport();
        McpSyncClient client = McpClient.sync((ClientMcpTransport)transport).requestTimeout(TIMEOUT).toolsChangeConsumer(tools -> toolsNotificationReceived.set(true)).resourcesChangeConsumer(resources -> resourcesNotificationReceived.set(true)).promptsChangeConsumer(prompts -> promptsNotificationReceived.set(true)).build();
        Assertions.assertThatCode(() -> {
            client.initialize();
            client.sendResourcesListChanged();
            client.promptListChangedNotification();
            client.close();
        }).doesNotThrowAnyException();
    }

    @Test
    void testLoggingLevels() {
        for (McpSchema.LoggingLevel level : McpSchema.LoggingLevel.values()) {
            Assertions.assertThatCode(() -> this.mcpSyncClient.setLoggingLevel(level)).doesNotThrowAnyException();
        }
    }

    @Test
    void testLoggingConsumer() {
        AtomicBoolean logReceived = new AtomicBoolean(false);
        ClientMcpTransport transport = this.createMcpTransport();
        McpSyncClient client = McpClient.sync((ClientMcpTransport)transport).requestTimeout(TIMEOUT).loggingConsumer(notification -> logReceived.set(true)).build();
        Assertions.assertThatCode(() -> {
            client.initialize();
            client.close();
        }).doesNotThrowAnyException();
    }

    @Test
    void testLoggingWithNullNotification() {
        Assertions.assertThatThrownBy(() -> this.mcpSyncClient.setLoggingLevel(null)).hasMessageContaining("Logging level must not be null");
    }
}

