/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.mdoclet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Tags {
    public static final String TEXT_TAG_NAME = "Text";
    private static final Pattern TAG_RE = Pattern.compile("\\{@[^\\}]*\\}");
    private static final Pattern SUBST_RE = Pattern.compile("\\{@\\}");
    private static Map<String, String> KINDS = new HashMap<String, String>();

    private Tags() {
    }

    public static String kindOf(String name) {
        String kind = KINDS.get(name);
        return kind == null ? name : kind;
    }

    public static String extractInlineTags(String comment, List<String> target) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = TAG_RE.matcher(comment);
        while (matcher.find()) {
            target.add(matcher.group());
            matcher.appendReplacement(result, "{@}");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String insertInlineTags(String comment, List<String> tags) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = SUBST_RE.matcher(comment);
        int index = 0;
        while (matcher.find()) {
            String tag = index < tags.size() ? tags.get(index++) : "{@}";
            matcher.appendReplacement(result, Matcher.quoteReplacement(tag));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    static {
        KINDS.put("@exception", "@throws");
        KINDS.put("@link", "@see");
        KINDS.put("@linkplain", "@see");
        KINDS.put("@serialData", "@serial");
    }
}

