/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.mdoclet;

import com.sun.javadoc.DocErrorReporter;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdrupes.mdoclet.MarkdownProcessor;
import org.jdrupes.mdoclet.processors.FlexmarkProcessor;

public class Options {
    public static final String OPT_MARKDOWN_PROCESSOR = "-markdown-processor";
    public static final String OPT_DISABLE_HIGHLIGHT = "-disable-highlight";
    public static final String OPT_DISABLE_AUTO_HIGHLIGHT = "-disable-auto-highlight";
    public static final String OPT_HIGHLIGHT_STYLE = "-highlight-style";
    public static final String OPT_ENCODING = "-encoding";
    public static final String OPT_OVERVIEW = "-overview";
    public static final String OPT_OUTPUT_DIR = "-d";
    public static final String OPT_STYLESHEETFILE = "-stylesheetfile";
    public static final String OPT_TAG = "-tag";
    private static final Pattern OPT_TAG_PATTERN = Pattern.compile("(?<tag>.*?)(?<!\\\\):(?<flags>[^:]*)(:(?<title>.*))?");
    private File overviewFile = null;
    private Charset encoding = null;
    private File destinationDir = null;
    private File stylesheetFile = null;
    private boolean highlightEnabled = true;
    private String highlightStyle = null;
    private Set<String> markedDownTags = new HashSet<String>();
    private static MarkdownProcessor processor = new FlexmarkProcessor();
    private static boolean processorUsed = false;
    private static List<String[]> processorOptions = new ArrayList<String[]>();

    public static int optionLength(String option) {
        if (option.startsWith("-M") || option.startsWith("-T")) {
            return 1;
        }
        switch (option) {
            case "-markdown-processor": 
            case "-highlight-style": 
            case "-disable-highlight": {
                return 2;
            }
            case "-disable-auto-highlight": {
                return processor.isSupportedOption("_disable-auto-highlight_") + 1;
            }
        }
        return Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter errorReporter) {
        String[][] forwardedOptions = new Options().load(options, errorReporter);
        if (forwardedOptions != null) {
            return Standard.validOptions((String[][])options, (DocErrorReporter)errorReporter);
        }
        return false;
    }

    public String[][] load(String[][] options, DocErrorReporter errorReporter) {
        LinkedList<String[]> optionsList = new LinkedList<String[]>();
        for (String[] opt : options) {
            optionsList.add(Arrays.copyOf(opt, opt.length));
        }
        Iterator<String[]> optionsIter = optionsList.iterator();
        while (optionsIter.hasNext()) {
            if (this.handleOption(optionsIter, errorReporter)) continue;
            return null;
        }
        return (String[][])optionsList.toArray((T[])new String[optionsList.size()][]);
    }

    protected boolean handleOption(Iterator<String[]> optionsIter, DocErrorReporter errorReporter) {
        String[] opt = optionsIter.next();
        switch (opt[0]) {
            case "-encoding": {
                try {
                    this.encoding = Charset.forName(opt[1]);
                }
                catch (IllegalCharsetNameException e) {
                    errorReporter.printError("Illegal charset: " + opt[1]);
                    return false;
                }
                return true;
            }
            case "-d": {
                if (this.destinationDir != null) {
                    errorReporter.printError("-d may only be specified once");
                }
                this.setDestinationDir(new File(opt[1]));
                return true;
            }
            case "-stylesheetfile": {
                if (this.stylesheetFile != null) {
                    errorReporter.printError("-stylesheetfile may only specified once");
                }
                this.setStylesheetFile(new File(opt[1]));
                return true;
            }
            case "-tag": {
                Matcher matcher = OPT_TAG_PATTERN.matcher(opt[1]);
                if (!matcher.matches()) {
                    return true;
                }
                if (!matcher.group("flags").contains("M")) {
                    return true;
                }
                this.markedDownTags.add(matcher.group("tag").replace("\\", ""));
                opt[1] = matcher.group("tag") + ":" + matcher.group("flags").replace("M", "");
                if (matcher.group("title") != null) {
                    opt[1] = opt[1] + ":" + matcher.group("title");
                }
                return true;
            }
            case "-overview": {
                if (this.getOverviewFile() != null) {
                    errorReporter.printError("-overview may only be specified once");
                    return false;
                }
                this.setOverviewFile(new File(opt[1]));
                return true;
            }
            case "-markdown-processor": {
                if (processorUsed) {
                    errorReporter.printError("Markdown processor cannot be changed after setting its options");
                    return false;
                }
                MarkdownProcessor proc = this.createProcessor(opt, errorReporter);
                if (proc == null) {
                    return false;
                }
                processor = proc;
                return true;
            }
            case "-disable-highlight": {
                this.highlightEnabled = false;
                optionsIter.remove();
                return true;
            }
            case "-disable-auto-highlight": {
                if (processor.isSupportedOption("_disable-auto-highlight_") == -1) {
                    return false;
                }
                processorOptions.add(new String[]{"_disable-auto-highlight_"});
                optionsIter.remove();
                return true;
            }
            case "-highlight-style": {
                if (this.highlightStyle != null) {
                    errorReporter.printError("Only one -highlight-style option allowed");
                    return false;
                }
                this.highlightStyle = opt[1];
                optionsIter.remove();
                break;
            }
        }
        if (opt[0].startsWith("-M")) {
            processorUsed = true;
            String[] procOpt = Options.unpackOption(opt[0].substring(2));
            if (processor.isSupportedOption(procOpt[0]) == -1) {
                return false;
            }
            processorOptions.add(procOpt);
            optionsIter.remove();
            return true;
        }
        return true;
    }

    private static String[] unpackOption(String option) {
        ArrayList<String> opts = new ArrayList<String>();
        String[] eqSplit = option.split("=", 2);
        opts.add(eqSplit[0]);
        if (eqSplit.length > 1) {
            String[] valSplit = eqSplit[1].split("(?<!\\\\),");
            Arrays.stream(valSplit).map(s -> s.replace("\\,", ",")).forEach(s -> opts.add((String)s));
        }
        return opts.toArray(new String[opts.size()]);
    }

    private MarkdownProcessor createProcessor(String[] opt, DocErrorReporter errorReporter) {
        try {
            Class<?> mpc = this.getClass().getClassLoader().loadClass(opt[1]);
            return (MarkdownProcessor)mpc.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            errorReporter.printError("Markdown processor \"" + opt[1] + "\" cannot be loaded (" + e.getMessage() + "), check name and docletpath");
            return null;
        }
    }

    public MarkdownProcessor getProcessor() {
        return processor;
    }

    public String[][] getProcessorOptions() {
        return (String[][])processorOptions.toArray((T[])new String[processorOptions.size()][]);
    }

    public String[] getMarkedDownTags() {
        return this.markedDownTags.toArray(new String[this.markedDownTags.size()]);
    }

    public File getOverviewFile() {
        return this.overviewFile;
    }

    public void setOverviewFile(File overviewFile) {
        this.overviewFile = overviewFile;
    }

    public Charset getEncoding() {
        return this.encoding != null ? this.encoding : Charset.defaultCharset();
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public File getDestinationDir() {
        if (this.destinationDir == null) {
            this.destinationDir = new File(System.getProperty("user.dir"));
        }
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public File getStylesheetFile() {
        return this.stylesheetFile;
    }

    public void setStylesheetFile(File stylesheetFile) {
        this.stylesheetFile = stylesheetFile;
    }

    public boolean isHighlightEnabled() {
        return this.highlightEnabled;
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        this.highlightEnabled = highlightEnabled;
    }

    public String getHighlightStyle() {
        return this.highlightStyle != null ? this.highlightStyle : "default";
    }

    public void setHighlightStyle(String highlightStyle) {
        this.highlightStyle = highlightStyle;
    }
}

