/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.ExceptionalReturnContentException;
import si.mazi.rescu.HttpStatusException;
import si.mazi.rescu.HttpStatusIOException;
import si.mazi.rescu.InvocationResult;
import si.mazi.rescu.RestMethodMetadata;
import si.mazi.rescu.Utils;

public abstract class ResponseReader {
    private static final Logger log = LoggerFactory.getLogger(ResponseReader.class);
    public static final int BODY_FRAGMENT_CHARS = 200;
    private final boolean ignoreHttpErrorCodes;

    public ResponseReader(boolean ignoreHttpErrorCodes) {
        this.ignoreHttpErrorCodes = ignoreHttpErrorCodes;
    }

    public boolean isIgnoreHttpErrorCodes() {
        return this.ignoreHttpErrorCodes;
    }

    public Object read(InvocationResult invocationResult, RestMethodMetadata methodMetadata) throws IOException {
        boolean isHttpStatusPass;
        String httpBody = invocationResult.getHttpBody();
        Throwable normalParseFailCause = null;
        boolean bl = isHttpStatusPass = !invocationResult.isErrorStatusCode() || this.isIgnoreHttpErrorCodes();
        if (isHttpStatusPass) {
            if (httpBody == null || httpBody.length() == 0) {
                return null;
            }
            try {
                return this.read(httpBody, methodMetadata.getReturnType());
            }
            catch (IOException | RuntimeException e) {
                normalParseFailCause = (Exception)ResponseReader.findCause((Throwable)e, (Class[])new Class[]{ExceptionalReturnContentException.class, JsonMappingException.class});
                if (normalParseFailCause == null) {
                    throw e;
                }
                log.debug("Parsing response as {} failed: {}", (Object)methodMetadata.getReturnType(), (Object)normalParseFailCause.toString());
            }
        }
        if (methodMetadata.getExceptionType() != null && httpBody != null) {
            RuntimeException exception = null;
            try {
                exception = this.readException(httpBody, methodMetadata.getExceptionType());
            }
            catch (Exception e) {
                log.warn("Noncritical error parsing error output: " + Utils.clip(httpBody, 200), (Throwable)e);
            }
            if (exception != null) {
                if (exception.getMessage() == null) {
                    log.info("Constructed an exception with no message. Response body was: {}", (Object)Utils.clip(httpBody, 200));
                }
                if (exception instanceof HttpStatusException) {
                    ((HttpStatusException)((Object)exception)).setHttpStatusCode(invocationResult.getStatusCode());
                }
                throw exception;
            }
        }
        String exceptionMessage = normalParseFailCause instanceof ExceptionalReturnContentException ? String.format("Response body could not be parsed as method return type %s: %s", methodMetadata.getReturnType(), normalParseFailCause.getMessage()) : (isHttpStatusPass ? normalParseFailCause.getMessage() : "HTTP status code was not OK: " + invocationResult.getStatusCode());
        throw new HttpStatusIOException(exceptionMessage, invocationResult);
    }

    protected abstract <T> T read(String var1, Type var2) throws IOException, ExceptionalReturnContentException;

    protected abstract RuntimeException readException(String var1, Class<? extends RuntimeException> var2) throws IOException;

    @SafeVarargs
    public static <T extends Throwable, C extends Class<? extends T>> T findCause(Throwable root, C ... ofClasses) {
        for (C c : ofClasses) {
            for (Throwable t = root; t != null; t = t.getCause()) {
                if (!((Class)c).isInstance(t)) continue;
                return (T)((Throwable)((Class)c).cast(t));
            }
        }
        return null;
    }
}

