/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import com.github.mkolisnyk.cucumber.assertions.LazyAssertionError;
import cucumber.api.Pending;
import cucumber.api.Scenario;
import cucumber.api.SummaryPrinter;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Reflections;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.ScenarioImpl;
import cucumber.runtime.Stats;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.StopWatch;
import cucumber.runtime.UndefinedStepException;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ExtendedRuntime
extends Runtime {
    private static final String[] PENDING_EXCEPTIONS = new String[]{"org.junit.AssumptionViolatedException", "org.junit.internal.AssumptionViolatedException"};
    private static final Object DUMMY_ARG;
    private static final byte ERRORS = 1;
    private final Stats stats;
    private final UndefinedStepsTracker undefinedStepsTracker = new UndefinedStepsTracker();
    private final Glue glue;
    private final RuntimeOptions runtimeOptions;
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final Collection<? extends Backend> backends;
    private final ClassLoader classLoader;
    private final StopWatch stopWatch;
    private boolean skipNextStep = false;
    private ScenarioImpl scenarioResult = null;

    public ExtendedRuntime(ResourceLoader resourceLoaderValue, ClassFinder classFinder, ClassLoader classLoaderValue, RuntimeOptions runtimeOptionsValue) {
        this(resourceLoaderValue, classLoaderValue, ExtendedRuntime.loadBackends(resourceLoaderValue, classFinder), runtimeOptionsValue);
    }

    public ExtendedRuntime(ResourceLoader resourceLoaderValue, ClassLoader classLoaderValue, Collection<? extends Backend> backendsValue, RuntimeOptions runtimeOptionsValue) {
        this(resourceLoaderValue, classLoaderValue, backendsValue, runtimeOptionsValue, StopWatch.SYSTEM, null);
    }

    public ExtendedRuntime(ResourceLoader resourceLoaderValue, ClassLoader classLoaderValue, Collection<? extends Backend> backendsValue, RuntimeOptions runtimeOptionsValue, RuntimeGlue optionalGlueValue) {
        this(resourceLoaderValue, classLoaderValue, backendsValue, runtimeOptionsValue, StopWatch.SYSTEM, optionalGlueValue);
    }

    public ExtendedRuntime(ResourceLoader resourceLoaderValue, ClassLoader classLoaderValue, Collection<? extends Backend> backendsValue, RuntimeOptions runtimeOptionsValue, StopWatch stopWatchValue, RuntimeGlue optionalGlueValue) {
        super(resourceLoaderValue, classLoaderValue, backendsValue, runtimeOptionsValue, stopWatchValue, optionalGlueValue);
        if (backendsValue.isEmpty()) {
            throw new CucumberException("No backends were found. Please make sure you have a backend module on your CLASSPATH.");
        }
        this.classLoader = classLoaderValue;
        this.backends = backendsValue;
        this.runtimeOptions = runtimeOptionsValue;
        this.stopWatch = stopWatchValue;
        this.glue = optionalGlueValue != null ? optionalGlueValue : new RuntimeGlue(this.undefinedStepsTracker, new LocalizedXStreams(classLoaderValue));
        this.stats = new Stats(runtimeOptionsValue.isMonochrome());
        for (Backend backend : this.backends) {
            backend.loadGlue(this.glue, this.runtimeOptions.getGlue());
            backend.setUnreportedStepExecutor((UnreportedStepExecutor)this);
        }
    }

    private static Collection<? extends Backend> loadBackends(ResourceLoader resourceLoader, ClassFinder classFinder) {
        Reflections reflections = new Reflections(classFinder);
        return reflections.instantiateSubclasses(Backend.class, "cucumber.runtime", new Class[]{ResourceLoader.class}, new Object[]{resourceLoader});
    }

    private void addStepToCounterAndResult(Result result) {
        this.scenarioResult.add(result);
        this.stats.addStep(result);
    }

    public void addError(Throwable error) {
        this.errors.add(error);
    }

    public void printSummary() {
        SummaryPrinter summaryPrinter = this.runtimeOptions.summaryPrinter(this.classLoader);
        summaryPrinter.print((Runtime)this);
    }

    void printStats(PrintStream out) {
        this.stats.printStats(out, this.runtimeOptions.isStrict());
    }

    public void buildBackendWorlds(Reporter reporter, Set<Tag> tags, gherkin.formatter.model.Scenario gherkinScenario) {
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
        this.undefinedStepsTracker.reset();
        this.skipNextStep = false;
        this.scenarioResult = new ScenarioImpl(reporter, tags, gherkinScenario);
    }

    public void disposeBackendWorlds(String scenarioDesignation) {
        this.stats.addScenario(this.scenarioResult.getStatus(), scenarioDesignation);
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public byte exitStatus() {
        byte result = 0;
        if (this.hasErrors() || this.hasUndefinedOrPendingStepsAndIsStrict()) {
            result = (byte)(result | 1);
        }
        return result;
    }

    private boolean hasUndefinedOrPendingStepsAndIsStrict() {
        return this.runtimeOptions.isStrict() && this.hasUndefinedOrPendingSteps();
    }

    private boolean hasUndefinedOrPendingSteps() {
        return this.hasUndefinedSteps() || this.hasPendingSteps();
    }

    private boolean hasUndefinedSteps() {
        return this.undefinedStepsTracker.hasUndefinedSteps();
    }

    private boolean hasPendingSteps() {
        return !this.errors.isEmpty() && !this.hasErrors();
    }

    private boolean hasErrors() {
        for (Throwable error : this.errors) {
            if (ExtendedRuntime.isPending(error)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSnippets() {
        return this.undefinedStepsTracker.getSnippets(this.backends, this.runtimeOptions.getSnippetType().getFunctionNameGenerator());
    }

    public Glue getGlue() {
        return this.glue;
    }

    public void runBeforeHooks(Reporter reporter, Set<Tag> tags) {
        this.runHooks(this.glue.getBeforeHooks(), reporter, tags, true);
    }

    public void runAfterHooks(Reporter reporter, Set<Tag> tags) {
        this.runHooks(this.glue.getAfterHooks(), reporter, tags, false);
    }

    private void runHooks(List<HookDefinition> hooks, Reporter reporter, Set<Tag> tags, boolean isBefore) {
        if (!this.runtimeOptions.isDryRun()) {
            for (HookDefinition hook : hooks) {
                this.runHookIfTagsMatch(hook, reporter, tags, isBefore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHookIfTagsMatch(HookDefinition hook, Reporter reporter, Set<Tag> tags, boolean isBefore) {
        if (hook.matches(tags)) {
            String status = "passed";
            Throwable error = null;
            Match match = new Match(Collections.emptyList(), hook.getLocation(false));
            this.stopWatch.start();
            try {
                hook.execute((Scenario)this.scenarioResult);
            }
            catch (Throwable t) {
                error = t;
                status = ExtendedRuntime.isPending(t) ? "pending" : "failed";
                this.addError(t);
                this.skipNextStep = true;
            }
            finally {
                long duration = this.stopWatch.stop();
                Result result = new Result(status, Long.valueOf(duration), error, DUMMY_ARG);
                this.addHookToCounterAndResult(result);
                if (isBefore) {
                    reporter.before(match, result);
                } else {
                    reporter.after(match, result);
                }
            }
        }
    }

    public void runUnreportedStep(String featurePath, I18n i18n, String stepKeyword, String stepName, int line, List<DataTableRow> dataTableRows, DocString docString) throws Throwable {
        Step step = new Step(Collections.emptyList(), stepKeyword, stepName, Integer.valueOf(line), dataTableRows, docString);
        StepDefinitionMatch match = this.glue.stepDefinitionMatch(featurePath, step, i18n);
        if (match == null) {
            UndefinedStepException error = new UndefinedStepException(step);
            StackTraceElement[] originalTrace = error.getStackTrace();
            StackTraceElement[] newTrace = new StackTraceElement[originalTrace.length + 1];
            newTrace[0] = new StackTraceElement("\u273d", "StepDefinition", featurePath, line);
            System.arraycopy(originalTrace, 0, newTrace, 1, originalTrace.length);
            error.setStackTrace(newTrace);
            throw error;
        }
        match.runStep(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStep(String featurePath, Step step, Reporter reporter, I18n i18n) {
        StepDefinitionMatch match;
        try {
            match = this.getGlue().stepDefinitionMatch(featurePath, step, i18n);
        }
        catch (AmbiguousStepDefinitionsException e) {
            reporter.match((Match)e.getMatches().get(0));
            Result result = new Result("failed", Long.valueOf(0L), (Throwable)e, DUMMY_ARG);
            reporter.result(result);
            this.addStepToCounterAndResult(result);
            this.addError(e);
            this.skipNextStep = true;
            return;
        }
        if (match == null) {
            reporter.match(Match.UNDEFINED);
            reporter.result(Result.UNDEFINED);
            this.addStepToCounterAndResult(Result.UNDEFINED);
            this.skipNextStep = true;
            return;
        }
        reporter.match((Match)match);
        if (this.runtimeOptions.isDryRun()) {
            this.skipNextStep = true;
        }
        if (this.skipNextStep) {
            this.addStepToCounterAndResult(Result.SKIPPED);
            reporter.result(Result.SKIPPED);
        } else {
            String status = "passed";
            Throwable error = null;
            this.stopWatch.start();
            try {
                match.runStep(i18n);
            }
            catch (LazyAssertionError t) {
                error = t;
                status = "failed";
                this.addError(t);
            }
            catch (Throwable t) {
                error = t;
                status = ExtendedRuntime.isPending(t) ? "pending" : "failed";
                this.addError(t);
                this.skipNextStep = true;
            }
            finally {
                long duration = this.stopWatch.stop();
                Result result = new Result(status, Long.valueOf(duration), error, DUMMY_ARG);
                this.addStepToCounterAndResult(result);
                reporter.result(result);
            }
        }
    }

    public static boolean isPending(Throwable t) {
        if (t == null) {
            return false;
        }
        return t.getClass().isAnnotationPresent(Pending.class) || Arrays.binarySearch(PENDING_EXCEPTIONS, t.getClass().getName()) >= 0;
    }

    private void addHookToCounterAndResult(Result result) {
        this.scenarioResult.add(result);
        this.stats.addHookTime(result.getDuration());
    }

    static {
        Arrays.sort(PENDING_EXCEPTIONS);
        DUMMY_ARG = new Object();
    }
}

