/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.runner.AfterSubSuite;
import com.github.mkolisnyk.cucumber.runner.AfterSuite;
import com.github.mkolisnyk.cucumber.runner.BeforeSubSuite;
import com.github.mkolisnyk.cucumber.runner.BeforeSuite;
import com.github.mkolisnyk.cucumber.runner.ExtendedCucumberOptions;
import com.github.mkolisnyk.cucumber.runner.ExtendedFeatureRunner;
import com.github.mkolisnyk.cucumber.runner.ReportRunner;
import com.github.mkolisnyk.cucumber.runner.RetryAcceptance;
import com.github.mkolisnyk.cucumber.runner.runtime.BaseRuntimeOptionsFactory;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import cucumber.api.CucumberOptions;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.junit.Assertions;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class ExtendedCucumber
extends ParentRunner<ExtendedFeatureRunner> {
    private JUnitReporter jUnitReporter;
    private final List<ExtendedFeatureRunner> children = new ArrayList<ExtendedFeatureRunner>();
    private final Runtime runtime;
    private final ExtendedRuntimeOptions[] extendedOptions;
    private Class clazzValue;
    private int retryCount = 0;
    private int threadsCount = 1;
    private boolean runPreDefined = true;

    public ExtendedCucumber(Class clazz) throws Exception {
        super(clazz);
        this.clazzValue = clazz;
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.runtime = this.createRuntime((ResourceLoader)resourceLoader, classLoader, runtimeOptions);
        this.extendedOptions = ExtendedRuntimeOptions.init((Class)clazz);
        this.init(runtimeOptions, classLoader, (ResourceLoader)resourceLoader);
    }

    public ExtendedCucumber(Class clazz, CucumberOptions baseOptions, ExtendedCucumberOptions[] extendedOptionsValue, boolean runPreDefinedValue) throws Exception {
        super(clazz);
        this.clazzValue = clazz;
        this.runPreDefined = runPreDefinedValue;
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        BaseRuntimeOptionsFactory runtimeOptionsFactory = new BaseRuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create(baseOptions);
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.runtime = this.createRuntime((ResourceLoader)resourceLoader, classLoader, runtimeOptions);
        this.extendedOptions = ExtendedRuntimeOptions.init((ExtendedCucumberOptions[])extendedOptionsValue);
        this.init(runtimeOptions, classLoader, (ResourceLoader)resourceLoader);
    }

    private void init(RuntimeOptions runtimeOptions, ClassLoader classLoader, ResourceLoader resourceLoader) throws Exception {
        for (ExtendedRuntimeOptions option : this.extendedOptions) {
            this.retryCount = Math.max(this.retryCount, option.getRetryCount());
            this.threadsCount = Math.max(this.threadsCount, option.getThreadsCount());
        }
        JUnitOptions junitOptions = new JUnitOptions(runtimeOptions.getJunitOptions());
        List cucumberFeatures = runtimeOptions.cucumberFeatures(resourceLoader);
        this.jUnitReporter = new JUnitReporter(runtimeOptions.reporter(classLoader), runtimeOptions.formatter(classLoader), runtimeOptions.isStrict(), junitOptions);
        Method[] retryMethods = this.getPredefinedMethods(RetryAcceptance.class);
        this.addChildren(cucumberFeatures, retryMethods);
    }

    protected Runtime createRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) throws InitializationError, IOException {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        return new Runtime(resourceLoader, (ClassFinder)classFinder, classLoader, runtimeOptions);
    }

    public List<ExtendedFeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ExtendedFeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(ExtendedFeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private Method[] getPredefinedMethods(Class annotation) {
        Method[] methodList;
        if (!annotation.isAnnotation()) {
            return new Method[0];
        }
        Object[] filteredMethodList = new Method[]{};
        for (Method method : methodList = this.clazzValue.getMethods()) {
            Annotation[] annotations;
            for (Annotation item : annotations = method.getAnnotations()) {
                if (!item.annotationType().equals(annotation)) continue;
                filteredMethodList = (Method[])ArrayUtils.add((Object[])filteredMethodList, (Object)method);
            }
        }
        return filteredMethodList;
    }

    private void runPredefinedMethods(Class annotation) throws Exception {
        Method[] methodList;
        if (!annotation.isAnnotation()) {
            return;
        }
        for (Method method : methodList = this.getPredefinedMethods(annotation)) {
            method.invoke(null, new Object[0]);
        }
    }

    public void run(RunNotifier notifier) {
        try {
            if (this.runPreDefined) {
                this.runPredefinedMethods(BeforeSuite.class);
            }
            this.runPredefinedMethods(BeforeSubSuite.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.run(notifier);
        try {
            if (this.runPreDefined) {
                this.runPredefinedMethods(AfterSuite.class);
            }
            this.runPredefinedMethods(AfterSubSuite.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.runtime.printSummary();
        this.jUnitReporter.done();
        this.jUnitReporter.close();
        for (ExtendedRuntimeOptions extendedOption : this.extendedOptions) {
            ReportRunner.run((ExtendedRuntimeOptions)extendedOption);
        }
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures, Method[] retryMethods) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            this.children.add(new ExtendedFeatureRunner(cucumberFeature, this.runtime, this.jUnitReporter, this.retryCount, retryMethods));
        }
    }
}

