/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.runner.ReportRunner;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.VERIFY)
public class ReportRunnerMavenPlugin
extends AbstractMojo {
    @Parameter
    private String breakdownConfig = "";
    @Parameter
    private boolean breakdownReport = false;
    @Parameter
    private boolean consolidatedReport = false;
    @Parameter
    private String consolidatedReportConfig = "";
    @Parameter
    private List<String> excludeCoverageTags = new ArrayList<String>();
    @Parameter
    private String featureMapConfig = "";
    @Parameter
    private boolean featureMapReport = false;
    @Parameter
    private boolean featureOverviewChart = false;
    @Parameter
    private List<String> includeCoverageTags = new ArrayList<String>();
    @Parameter
    private boolean isCoverageReport = false;
    @Parameter
    private boolean isDetailedAggregatedReport = false;
    @Parameter
    private boolean isDetailedReport = false;
    @Parameter
    private boolean isOverviewReport = false;
    @Parameter
    private boolean isUsageReport = false;
    @Parameter
    private List<String> jsonReportPaths;
    @Parameter
    private List<String> jsonUsageReportPaths;
    @Parameter
    private String knownErrorsConfig = "";
    @Parameter
    private boolean knownErrorsReport = false;
    @Parameter
    private String outputFolder;
    @Parameter
    private String pdfPageSize = "auto";
    @Parameter
    private String reportPrefix = "cucumber-reports";
    @Parameter
    private String screenShotLocation = "";
    @Parameter
    private String screenShotSize = "";
    @Parameter
    private boolean toPDF = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ExtendedRuntimeOptions options = new ExtendedRuntimeOptions();
        options.setBreakdownConfig(this.breakdownConfig);
        options.setBreakdownReport(this.breakdownReport);
        options.setConsolidatedReport(this.consolidatedReport);
        options.setConsolidatedReportConfig(this.consolidatedReportConfig);
        options.setCoverageReport(this.isCoverageReport);
        options.setDetailedAggregatedReport(this.isDetailedAggregatedReport);
        options.setDetailedReport(this.isDetailedReport);
        String[] tags = new String[this.excludeCoverageTags.size()];
        options.setExcludeCoverageTags(this.excludeCoverageTags.toArray(tags));
        tags = new String[this.includeCoverageTags.size()];
        options.setIncludeCoverageTags(this.includeCoverageTags.toArray(tags));
        options.setFeatureMapConfig(this.featureMapConfig);
        options.setFeatureMapReport(this.featureMapReport);
        options.setFeatureOverviewChart(this.featureOverviewChart);
        String[] paths = new String[this.jsonReportPaths.size()];
        options.setJsonReportPaths(this.jsonReportPaths.toArray(paths));
        paths = new String[this.jsonUsageReportPaths.size()];
        options.setJsonUsageReportPaths(this.jsonUsageReportPaths.toArray(paths));
        options.setKnownErrorsConfig(this.knownErrorsConfig);
        options.setKnownErrorsReport(this.knownErrorsReport);
        options.setOutputFolder(this.outputFolder);
        options.setOverviewReport(this.isOverviewReport);
        options.setPdfPageSize(this.pdfPageSize);
        options.setReportPrefix(this.reportPrefix);
        options.setScreenShotLocation(this.screenShotLocation);
        options.setScreenShotSize(this.screenShotSize);
        options.setToPDF(this.toPDF);
        options.setUsageReport(this.isUsageReport);
        ReportRunner.run(options);
    }

    public void setBreakdownConfig(String breakdownConfigValue) {
        this.breakdownConfig = breakdownConfigValue;
    }

    public void setBreakdownReport(boolean breakdownReportValue) {
        this.breakdownReport = breakdownReportValue;
    }

    public void setConsolidatedReport(boolean consolidatedReportValue) {
        this.consolidatedReport = consolidatedReportValue;
    }

    public void setConsolidatedReportConfig(String consolidatedReportConfigValue) {
        this.consolidatedReportConfig = consolidatedReportConfigValue;
    }

    public void setCoverageReport(boolean isCoverageReportValue) {
        this.isCoverageReport = isCoverageReportValue;
    }

    public void setDetailedAggregatedReport(boolean isDetailedAggregatedReportValue) {
        this.isDetailedAggregatedReport = isDetailedAggregatedReportValue;
    }

    public void setDetailedReport(boolean isDetailedReportValue) {
        this.isDetailedReport = isDetailedReportValue;
    }

    public void setExcludeCoverageTags(List<String> excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue;
    }

    public void setFeatureMapConfig(String featureMapConfigValue) {
        this.featureMapConfig = featureMapConfigValue;
    }

    public void setFeatureMapReport(boolean featureMapReportValue) {
        this.featureMapReport = featureMapReportValue;
    }

    public void setFeatureOverviewChart(boolean featureOverviewChartValue) {
        this.featureOverviewChart = featureOverviewChartValue;
    }

    public void setIncludeCoverageTags(List<String> includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue;
    }

    public void setJsonReportPaths(List<String> jsonReportPathsValue) {
        this.jsonReportPaths = jsonReportPathsValue;
    }

    public void setJsonUsageReportPaths(List<String> jsonUsageReportPathsValue) {
        this.jsonUsageReportPaths = jsonUsageReportPathsValue;
    }

    public void setKnownErrorsConfig(String knownErrorsConfigValue) {
        this.knownErrorsConfig = knownErrorsConfigValue;
    }

    public void setKnownErrorsReport(boolean knownErrorsReportValue) {
        this.knownErrorsReport = knownErrorsReportValue;
    }

    public void setOutputFolder(String outputFolderValue) {
        this.outputFolder = outputFolderValue;
    }

    public void setOverviewReport(boolean isOverviewReportValue) {
        this.isOverviewReport = isOverviewReportValue;
    }

    public void setPdfPageSize(String pdfPageSizeValue) {
        this.pdfPageSize = pdfPageSizeValue;
    }

    public void setReportPrefix(String reportPrefixValue) {
        this.reportPrefix = reportPrefixValue;
    }

    public void setScreenShotLocation(String screenShotLocationValue) {
        this.screenShotLocation = screenShotLocationValue;
    }

    public void setScreenShotSize(String screenShotSizeValue) {
        this.screenShotSize = screenShotSizeValue;
    }

    public void setToPDF(boolean toPDFValue) {
        this.toPDF = toPDFValue;
    }

    public void setUsageReport(boolean isUsageReportValue) {
        this.isUsageReport = isUsageReportValue;
    }
}

