/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.utils.drawers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class PieChartDrawer {
    private final double scale = 0.2;
    private final double centerScale = 3.0;
    private double startAngle;
    private double endAngle;
    private double shiftAngle;
    private double centerX;
    private double centerY;

    private void initBaseDimensions(int width, int height, double accumulated, double sum, double value, double shift) {
        if (value == sum) {
            shift = 0.0;
        }
        this.startAngle = Math.PI * 2 * accumulated / sum;
        this.endAngle = Math.PI * 2 * (accumulated + value) / sum;
        this.shiftAngle = (this.startAngle + this.endAngle) / 2.0;
        this.centerX = (double)width / 3.0 + shift * Math.sin(this.shiftAngle);
        this.centerY = (double)height / 3.0 - shift * Math.cos(this.shiftAngle);
    }

    private String drawPieBorders(int width, int height, int[] values, String[] colors, int pieVOffset, int shift) {
        int i;
        int sum = Arrays.stream(values).sum();
        String drawing = "";
        int accumulated = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.initBaseDimensions(width, height, accumulated, sum, values[i], shift);
            double startX = this.centerX + 0.2 * (double)width * Math.sin(this.startAngle) + (double)shift * Math.sin(this.shiftAngle);
            double startY = this.centerY - 0.2 * (double)height * Math.cos(this.startAngle) - (double)shift * Math.cos(this.shiftAngle);
            drawing = drawing.concat(String.format(Locale.US, "<path fill=\"%s\" stroke-width=\"1\" stroke=\"%s\" d=\"M%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f \"></path>", colors[i], colors[i], this.centerX, this.centerY + (double)pieVOffset, startX, startY + (double)pieVOffset, startX, startY, this.centerX, this.centerY, this.centerX, this.centerY + (double)pieVOffset));
            accumulated += values[i];
        }
        accumulated = 0;
        for (i = 0; i < values.length; ++i) {
            this.startAngle = Math.PI * 2 * (double)accumulated / (double)sum;
            this.endAngle = Math.PI * 2 * (double)(accumulated + values[i]) / (double)sum;
            this.shiftAngle = (this.startAngle + this.endAngle) / 2.0;
            this.centerX = (double)width / 3.0 + (double)shift * Math.sin(this.shiftAngle);
            this.centerY = (double)height / 3.0 - (double)shift * Math.cos(this.shiftAngle);
            double endX = 0.0;
            double endY = 0.0;
            if (i < values.length - 1) {
                endX = this.centerX + 0.2 * (double)width * Math.sin(this.endAngle) + (double)shift * Math.sin(this.shiftAngle);
                endY = this.centerY - 0.2 * (double)height * Math.cos(this.endAngle) - (double)shift * Math.cos(this.shiftAngle);
            } else {
                endX = this.centerX + (double)shift * Math.sin(this.shiftAngle);
                endY = this.centerY - 0.2 * (double)height - (double)shift * Math.cos(this.shiftAngle);
            }
            drawing = drawing.concat(String.format(Locale.US, "<path fill=\"%s\" stroke-width=\"1\" stroke=\"%s\" d=\"M%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f \"></path>", colors[i], colors[i], this.centerX, this.centerY + (double)pieVOffset, endX, endY + (double)pieVOffset, endX, endY, this.centerX, this.centerY, this.centerX, this.centerY + (double)pieVOffset));
            accumulated += values[i];
        }
        return drawing;
    }

    private String drawPieLayer(int width, int height, int[] values, String[] colors, int pieVOffset, int shift) {
        int sum = Arrays.stream(values).sum();
        String drawing = "";
        int accumulated = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.initBaseDimensions(width, height, accumulated, sum, values[i], shift);
            double radiusX = 0.2 * (double)width;
            double radiusY = 0.2 * (double)height;
            int pieParts = 5;
            for (int j = 0; j < 5; ++j) {
                double angleDiff = this.endAngle - this.startAngle;
                double startX = this.centerX + 0.2 * (double)width * Math.sin(this.startAngle + (double)j * angleDiff / 5.0) + (double)shift * Math.sin(this.shiftAngle);
                double startY = this.centerY - 0.2 * (double)height * Math.cos(this.startAngle + (double)j * angleDiff / 5.0) - (double)shift * Math.cos(this.shiftAngle);
                double endX = this.centerX + 0.2 * (double)width * Math.sin(this.startAngle + (double)(j + 1) * angleDiff / 5.0) + (double)shift * Math.sin(this.shiftAngle);
                double endY = this.centerY - 0.2 * (double)height * Math.cos(this.startAngle + (double)(j + 1) * angleDiff / 5.0) - (double)shift * Math.cos(this.shiftAngle);
                drawing = drawing.concat(String.format(Locale.US, "<path fill=\"%s\" stroke-width=\"1\" stroke=\"%s\" d=\"M%.8f,%.8f L%.8f,%.8f A%.8f,%.8f,0,%d,1,%.8f,%.8f M%.8f,%.8f L%.8f,%.8f\"></path>", colors[i], colors[i], this.centerX, this.centerY + (double)pieVOffset, startX, startY + (double)pieVOffset, radiusX, radiusY, 0, endX, endY + (double)pieVOffset, endX, endY + (double)pieVOffset, this.centerX, this.centerY + (double)pieVOffset));
            }
            accumulated += values[i];
        }
        return drawing;
    }

    public String generatePieChart(int width, int height, int[] values, String[] labels, String[] colors, String[] shadowColors, int pieThickness, int shift) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/printable_chart.html");
        String result = IOUtils.toString((InputStream)is);
        is.close();
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        String drawing = "";
        drawing = drawing.concat(this.drawPieLayer(width, height, values, shadowColors, pieThickness, shift));
        drawing = drawing.concat(this.drawPieBorders(width, height, values, shadowColors, pieThickness, shift));
        drawing = drawing.concat(this.drawPieLayer(width, height, values, colors, 0, shift));
        for (int i = 0; i < values.length; ++i) {
            double xShiftScale = 0.6;
            double yShiftScale = 0.15;
            int xOffset = 10;
            int yHeight = 30;
            double maxRate = 100.0;
            drawing = drawing.concat(String.format(Locale.US, "<text x=\"%d\" y=\"%d\" font-weight = \"bold\" font-size = \"14\">%.0f%% (%d) %s</text>", (int)(0.6 * (double)width) + 10, (int)(0.15 * (double)width) + 30 * i, 100.0 * (double)values[i] / (double)sum, values[i], labels[i]));
            drawing = drawing.concat(String.format(Locale.US, "<circle cx=\"%d\" cy=\"%d\" r=\"5\" stroke=\"%s\" stroke-width=\"1\" fill=\"%s\" />", (int)(0.6 * (double)width), (int)(0.15 * (double)width) + 30 * i - 5, shadowColors[i], colors[i]));
        }
        result = result.replaceAll("__DRAWING__", drawing);
        result = result.replaceAll("__HEIGHT__", String.valueOf(height));
        result = result.replaceAll("__WIDTH__", String.valueOf(width));
        return result;
    }
}

