/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.knownerrors;

import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.BaseMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.Matcher;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsInfo;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KnownErrorsResultSet {
    private List<KnownErrorsResult> results = new ArrayList<KnownErrorsResult>();

    public List<KnownErrorsResult> getResults() {
        Collections.sort(this.results);
        return this.results;
    }

    public void addResult(KnownErrorsResult result) {
        if (this.results.contains(result)) {
            int index = this.results.indexOf(result);
            int frequency = this.results.get(index).getFrequency() + 1;
            this.results.get(index).setFrequency(frequency);
        } else {
            result.setFrequency(1);
            this.results.add(result);
        }
    }

    public void valuate(CucumberScenarioResult[] scenarios, KnownErrorsModel model) {
        for (KnownErrorsInfo info : model.getErrorDescriptions()) {
            Matcher matcher = BaseMatcher.create(info.getFilter().getDimensionValue());
            for (CucumberScenarioResult scenario : scenarios) {
                if (!matcher.matches(scenario, info.getFilter())) continue;
                KnownErrorsResult result = new KnownErrorsResult();
                result.setFrequency(1);
                result.setInfo(info);
                result.setOrderBy(model.getOrderBy());
                this.addResult(result);
            }
        }
    }
}

