/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.lang;

import com.thebuzzmedia.exiftool.exceptions.UnreadableFileException;
import com.thebuzzmedia.exiftool.exceptions.UnwritableFileException;
import java.io.File;
import java.util.Map;

public final class PreConditions {
    private PreConditions() {
    }

    public static <T> T notNull(T val, String message, Object ... params) {
        if (val == null) {
            throw new NullPointerException(PreConditions.errorMessage(message, params));
        }
        return val;
    }

    public static String notBlank(String val, String message, Object ... params) {
        PreConditions.notNull(val, message, params);
        if (val.length() == 0 || val.trim().length() == 0) {
            throw new IllegalArgumentException(PreConditions.errorMessage(message, params));
        }
        return val;
    }

    public static <T> T[] notEmpty(T[] val, String message, Object ... params) {
        PreConditions.notNull(val, message, params);
        if (val.length == 0) {
            throw new IllegalArgumentException(PreConditions.errorMessage(message, params));
        }
        return val;
    }

    public static <T, U> Map<T, U> notEmpty(Map<T, U> val, String message, Object ... params) {
        PreConditions.notNull(val, message, params);
        if (val.size() == 0) {
            throw new IllegalArgumentException(PreConditions.errorMessage(message, params));
        }
        return val;
    }

    public static <T> Iterable<T> notEmpty(Iterable<T> val, String message, Object ... params) {
        PreConditions.notNull(val, message, params);
        if (!val.iterator().hasNext()) {
            throw new IllegalArgumentException(PreConditions.errorMessage(message, params));
        }
        return val;
    }

    public static <T extends Number> T isPositive(T nb, String message, Object ... params) {
        PreConditions.notNull(nb, message, params);
        if (nb.doubleValue() <= 0.0) {
            throw new IllegalArgumentException(PreConditions.errorMessage(message, params));
        }
        return nb;
    }

    public static File isReadable(File file, String message, Object ... params) {
        PreConditions.notNull(file, message, params);
        if (!file.exists() || !file.canRead()) {
            throw new UnreadableFileException(file, PreConditions.errorMessage(message, params));
        }
        return file;
    }

    public static File isWritable(File file, String message, Object ... params) {
        PreConditions.notNull(file, message, params);
        if (!file.exists() || !file.canWrite()) {
            throw new UnwritableFileException(file, PreConditions.errorMessage(message, params));
        }
        return file;
    }

    private static String errorMessage(String message, Object[] params) {
        return params.length > 0 ? String.format(message, params) : message;
    }
}

