/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FsInfoStructure;
import com.github.mjdev.libaums.util.LRUCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/FAT;", "", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "bootSector", "Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "fsInfoStructure", "Lcom/github/mjdev/libaums/fs/fat32/FsInfoStructure;", "(Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;Lcom/github/mjdev/libaums/fs/fat32/FsInfoStructure;)V", "cache", "Lcom/github/mjdev/libaums/util/LRUCache;", "", "", "fatNumbers", "", "fatOffset", "", "alloc", "chain", "numberOfClusters", "", "alloc$libaums_release", "([Ljava/lang/Long;I)[Ljava/lang/Long;", "free", "free$libaums_release", "getChain", "startCluster", "getChain$libaums_release", "(J)[Ljava/lang/Long;", "Companion", "libaums_release"})
public final class FAT {
    private final long[] fatOffset;
    private int[] fatNumbers;
    private final LRUCache<Long, Long[]> cache;
    private final BlockDeviceDriver blockDevice;
    private final FsInfoStructure fsInfoStructure;
    private static final String TAG;
    private static final int FAT32_EOF_CLUSTER = 0xFFFFFF8;
    public static final Companion Companion;

    @NotNull
    public final Long[] getChain$libaums_release(long startCluster) throws IOException {
        if (startCluster == 0L) {
            return new Long[0];
        }
        Long[] cachedChain = (Long[])this.cache.get(startCluster);
        if (cachedChain != null) {
            return cachedChain;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long currentCluster = startCluster;
        long offset = 0L;
        long offsetInBlock = 0L;
        long lastOffset = -1L;
        do {
            result.add(currentCluster);
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset == offset) continue;
            buffer.clear();
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            this.blockDevice.read(offset, byteBuffer);
            lastOffset = offset;
        } while ((currentCluster = (long)(buffer.getInt((int)offsetInBlock) & 0xFFFFFFF)) < (long)0xFFFFFF8);
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Long[] longArray = thisCollection$iv.toArray(new Long[0]);
        if (longArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Long[] arr = longArray;
        ((Map)this.cache).put(startCluster, arr);
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Long[] alloc$libaums_release(@NotNull Long[] chain, int numberOfClusters) throws IOException {
        int numberOfClusters2;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        int originalNumberOfClusters = numberOfClusters2 = numberOfClusters;
        ArrayList<Long> result = new ArrayList<Long>(chain.length + numberOfClusters2);
        result.addAll((Collection)Arrays.asList(Arrays.copyOf(chain, chain.length)));
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Long[] longArray = chain;
        boolean bl = false;
        Long[] longArray2 = longArray;
        boolean bl2 = false;
        long cluster = !(longArray2.length == 0) ? chain[chain.length - 1] : -1L;
        long lastAllocated = this.fsInfoStructure.getLastAllocatedClusterHint();
        if (lastAllocated == (long)FsInfoStructure.Companion.getINVALID_VALUE()) {
            lastAllocated = 2L;
        }
        long currentCluster = lastAllocated;
        long offset = 0L;
        long offsetInBlock = 0L;
        long lastOffset = -1L;
        while (numberOfClusters2 > 0) {
            long l = currentCluster;
            currentCluster = l + 1L;
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                this.blockDevice.read(offset, byteBuffer);
                lastOffset = offset;
            }
            if (buffer.getInt((int)offsetInBlock) != 0) continue;
            result.add(currentCluster);
            --numberOfClusters2;
        }
        if ((int)cluster != -1) {
            offset = (this.fatOffset[0] + cluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + cluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                this.blockDevice.read(offset, byteBuffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, (int)((Number)result.get(chain.length)).longValue());
        }
        int n = chain.length;
        int n2 = result.size() - 1;
        while (n < n2) {
            void i;
            Object e = result.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"result[i]");
            currentCluster = ((Number)e).longValue();
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                this.blockDevice.write(lastOffset, byteBuffer);
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, (int)((Number)result.get((int)(i + true))).longValue());
            ++i;
        }
        Object e = result.get(result.size() - 1);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"result[result.size - 1]");
        currentCluster = ((Number)e).longValue();
        offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
        offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
        if (lastOffset != offset) {
            buffer.clear();
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            this.blockDevice.write(lastOffset, byteBuffer);
            buffer.clear();
            this.blockDevice.read(offset, buffer);
        }
        buffer.putInt((int)offsetInBlock, 0xFFFFFF8);
        buffer.clear();
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        this.blockDevice.write(offset, byteBuffer);
        this.fsInfoStructure.setLastAllocatedClusterHint(currentCluster);
        this.fsInfoStructure.decreaseClusterCount(originalNumberOfClusters);
        this.fsInfoStructure.write();
        Log.i((String)TAG, (String)"allocating clusters finished");
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Long[] longArray3 = thisCollection$iv.toArray(new Long[0]);
        if (longArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Long[] arr = longArray3;
        ((Map)this.cache).put(arr[0], arr);
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Long[] free$libaums_release(@NotNull Long[] chain, int numberOfClusters) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        int offsetInChain = chain.length - numberOfClusters;
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        boolean bl = offsetInChain >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "trying to remove more clusters in chain than currently exist!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        long currentCluster = 0L;
        long offset = 0L;
        long offsetInBlock = 0L;
        long lastOffset = -1L;
        int n = offsetInChain;
        int n2 = chain.length;
        while (n < n2) {
            void i;
            currentCluster = chain[i];
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                if ((int)lastOffset != -1) {
                    buffer.clear();
                    ByteBuffer byteBuffer = buffer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                    this.blockDevice.write(lastOffset, byteBuffer);
                }
                buffer.clear();
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                this.blockDevice.read(offset, byteBuffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, 0);
            ++i;
        }
        if (offsetInChain > 0) {
            currentCluster = chain[offsetInChain - 1];
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                this.blockDevice.write(lastOffset, byteBuffer);
                buffer.clear();
                this.blockDevice.read(offset, buffer);
            }
            buffer.putInt((int)offsetInBlock, 0xFFFFFF8);
            buffer.clear();
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            this.blockDevice.write(offset, byteBuffer);
        } else {
            buffer.clear();
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            this.blockDevice.write(lastOffset, byteBuffer);
        }
        Log.i((String)TAG, (String)("freed " + numberOfClusters + " clusters"));
        this.fsInfoStructure.decreaseClusterCount(-numberOfClusters);
        this.fsInfoStructure.write();
        Long[] arr = Arrays.copyOfRange(chain, 0, offsetInChain);
        Intrinsics.checkExpressionValueIsNotNull((Object)arr, (String)"arr");
        Long[] longArray = arr;
        boolean bl5 = false;
        Long[] longArray2 = longArray;
        boolean bl6 = false;
        if (!(longArray2.length == 0)) {
            ((Map)this.cache).put(arr[0], arr);
        }
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    public FAT(@NotNull BlockDeviceDriver blockDevice, @NotNull Fat32BootSector bootSector, @NotNull FsInfoStructure fsInfoStructure) {
        int n;
        int fatCount;
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkParameterIsNotNull((Object)bootSector, (String)"bootSector");
        Intrinsics.checkParameterIsNotNull((Object)fsInfoStructure, (String)"fsInfoStructure");
        this.blockDevice = blockDevice;
        this.fsInfoStructure = fsInfoStructure;
        this.cache = new LRUCache(64);
        if (!bootSector.isFatMirrored()) {
            byte fatNumber = bootSector.getValidFat();
            this.fatNumbers = new int[]{fatNumber};
            Log.i((String)TAG, (String)("fat is not mirrored, fat " + fatNumber + " is valid"));
        } else {
            fatCount = bootSector.getFatCount();
            this.fatNumbers = new int[fatCount];
            n = 0;
            int n2 = fatCount;
            while (n < n2) {
                void i;
                this.fatNumbers[i] = i;
                ++i;
            }
            Log.i((String)TAG, (String)("fat is mirrored, fat count: " + fatCount));
        }
        this.fatOffset = new long[this.fatNumbers.length];
        fatCount = 0;
        n = this.fatOffset.length;
        while (fatCount < n) {
            void i;
            this.fatOffset[i] = bootSector.getFatOffset(this.fatNumbers[i]);
            ++i;
        }
    }

    static {
        Companion = new Companion(null);
        String string = FAT.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FAT::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/FAT$Companion;", "", "()V", "FAT32_EOF_CLUSTER", "", "TAG", "", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

