/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u001d\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u001d\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010'\u001a\u00020$H\u0000\u00a2\u0006\u0002\b(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00038@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/ClusterChain;", "", "startCluster", "", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "fat", "Lcom/github/mjdev/libaums/fs/fat32/FAT;", "bootSector", "Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "(JLcom/github/mjdev/libaums/driver/BlockDeviceDriver;Lcom/github/mjdev/libaums/fs/fat32/FAT;Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;)V", "chain", "", "[Ljava/lang/Long;", "clusterSize", "newNumberOfClusters", "", "clusters", "getClusters", "()I", "setClusters", "(I)V", "dataAreaOffset", "newLength", "length", "getLength$libaums_release", "()J", "setLength$libaums_release", "(J)V", "getFileSystemOffset", "cluster", "clusterOffset", "read", "", "offset", "dest", "Ljava/nio/ByteBuffer;", "read$libaums_release", "write", "source", "write$libaums_release", "Companion", "libaums_release"})
public final class ClusterChain {
    private Long[] chain;
    private final long clusterSize;
    private final long dataAreaOffset;
    private final BlockDeviceDriver blockDevice;
    private final FAT fat;
    private static final String TAG;
    public static final Companion Companion;

    private final int getClusters() {
        return this.chain.length;
    }

    private final void setClusters(int newNumberOfClusters) throws IOException {
        Long[] longArray;
        int oldNumberOfClusters = this.getClusters();
        if (newNumberOfClusters == oldNumberOfClusters) {
            return;
        }
        if (newNumberOfClusters > oldNumberOfClusters) {
            Log.d((String)TAG, (String)"grow chain");
            longArray = this.fat.alloc$libaums_release(this.chain, newNumberOfClusters - oldNumberOfClusters);
        } else {
            Log.d((String)TAG, (String)"shrink chain");
            longArray = this.fat.free$libaums_release(this.chain, oldNumberOfClusters - newNumberOfClusters);
        }
        this.chain = longArray;
    }

    public final long getLength$libaums_release() {
        return (long)this.chain.length * this.clusterSize;
    }

    public final void setLength$libaums_release(long newLength) throws IOException {
        long newNumberOfClusters = (newLength + this.clusterSize - 1L) / this.clusterSize;
        this.setClusters((int)newNumberOfClusters);
    }

    public final void read$libaums_release(long offset, @NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        int length = dest.remaining();
        int chainIndex = (int)(offset / this.clusterSize);
        if (offset % this.clusterSize != 0L) {
            int clusterOffset = (int)(offset % this.clusterSize);
            int size = Math.min(length, (int)(this.clusterSize - (long)clusterOffset));
            dest.limit(dest.position() + size);
            this.blockDevice.read(this.getFileSystemOffset(this.chain[chainIndex], clusterOffset), dest);
            ++chainIndex;
            length -= size;
        }
        while (length > 0) {
            int size = (int)Math.min(this.clusterSize, (long)length);
            dest.limit(dest.position() + size);
            this.blockDevice.read(this.getFileSystemOffset(this.chain[chainIndex], 0), dest);
            ++chainIndex;
            length -= size;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void write$libaums_release(long offset, @NotNull ByteBuffer source) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        int length = source.remaining();
        int chainIndex = (int)(offset / this.clusterSize);
        if (offset % this.clusterSize != 0L) {
            int clusterOffset = (int)(offset % this.clusterSize);
            int n = (int)(this.clusterSize - (long)clusterOffset);
            boolean bl = false;
            int size = Math.min(length, n);
            source.limit(source.position() + size);
            this.blockDevice.write(this.getFileSystemOffset(this.chain[chainIndex], clusterOffset), source);
            ++chainIndex;
            length -= size;
        }
        long remainingClusters = (long)length / this.clusterSize;
        while (length > 0) {
            void i;
            int size = 0;
            int numberOfClusters = 1;
            int maxConsecutiveClusters = 1;
            int n = chainIndex;
            int n2 = this.chain.length - 1;
            while (n < n2 && this.chain[i] + 1L == this.chain[i + true]) {
                ++maxConsecutiveClusters;
                ++i;
            }
            n = 4;
            n2 = 0;
            maxConsecutiveClusters = Math.min(maxConsecutiveClusters, n);
            if (remainingClusters > (long)maxConsecutiveClusters) {
                size = (int)(this.clusterSize * (long)maxConsecutiveClusters);
                numberOfClusters = maxConsecutiveClusters;
                remainingClusters -= (long)maxConsecutiveClusters;
            } else if (remainingClusters > 0L) {
                n = (int)remainingClusters;
                long l = this.clusterSize;
                n2 = 0;
                int n3 = Math.min(n, maxConsecutiveClusters);
                size = (int)(l * (long)n3);
                n = (int)remainingClusters;
                n2 = 0;
                numberOfClusters = Math.min(n, maxConsecutiveClusters);
                remainingClusters -= (long)numberOfClusters;
            } else {
                size = length;
            }
            source.limit(source.position() + size);
            this.blockDevice.write(this.getFileSystemOffset(this.chain[chainIndex], 0), source);
            chainIndex += numberOfClusters;
            length -= size;
        }
    }

    private final long getFileSystemOffset(long cluster, int clusterOffset) {
        return this.dataAreaOffset + (long)clusterOffset + (cluster - (long)2) * this.clusterSize;
    }

    public ClusterChain(long startCluster, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkParameterIsNotNull((Object)fat, (String)"fat");
        Intrinsics.checkParameterIsNotNull((Object)bootSector, (String)"bootSector");
        this.blockDevice = blockDevice;
        this.fat = fat;
        Log.d((String)TAG, (String)"Init a cluster chain, reading from FAT");
        this.chain = this.fat.getChain$libaums_release(startCluster);
        this.clusterSize = bootSector.getBytesPerCluster();
        this.dataAreaOffset = bootSector.getDataAreaOffset();
        Log.d((String)TAG, (String)"Finished init of a cluster chain");
    }

    static {
        Companion = new Companion(null);
        String string = ClusterChain.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ClusterChain::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/ClusterChain$Companion;", "", "()V", "TAG", "", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

