/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/FsInfoStructure;", "", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "offset", "", "(Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;I)V", "buffer", "Ljava/nio/ByteBuffer;", "value", "", "freeClusterCount", "getFreeClusterCount", "()J", "setFreeClusterCount", "(J)V", "lastAllocatedClusterHint", "getLastAllocatedClusterHint", "setLastAllocatedClusterHint", "decreaseClusterCount", "", "numberOfClusters", "write", "Companion", "libaums_release"})
public final class FsInfoStructure {
    private final ByteBuffer buffer;
    private final BlockDeviceDriver blockDevice;
    private final int offset;
    private static int INVALID_VALUE;
    private static final int LEAD_SIGNATURE_OFF = 0;
    private static final int STRUCT_SIGNATURE_OFF = 484;
    private static final int TRAIL_SIGNATURE_OFF = 508;
    private static final int FREE_COUNT_OFF = 488;
    private static final int NEXT_FREE_OFFSET = 492;
    private static final int LEAD_SIGNATURE = 1096897106;
    private static final int STRUCT_SIGNATURE = 1631679090;
    private static final int TRAIL_SIGNATURE = -1437270016;
    private static final String TAG;
    public static final Companion Companion;

    public final long getFreeClusterCount() {
        return this.buffer.getInt(488);
    }

    public final void setFreeClusterCount(long value) {
        this.buffer.putInt(488, (int)value);
    }

    public final long getLastAllocatedClusterHint() {
        return this.buffer.getInt(492);
    }

    public final void setLastAllocatedClusterHint(long value) {
        this.buffer.putInt(492, (int)value);
    }

    public final void decreaseClusterCount(long numberOfClusters) {
        if (this.getFreeClusterCount() != (long)INVALID_VALUE) {
            FsInfoStructure fsInfoStructure = this;
            fsInfoStructure.setFreeClusterCount(fsInfoStructure.getFreeClusterCount() - numberOfClusters);
        }
    }

    public final void write() throws IOException {
        Log.d((String)TAG, (String)"writing to device");
        this.blockDevice.write(this.offset, this.buffer);
        this.buffer.clear();
    }

    private FsInfoStructure(BlockDeviceDriver blockDevice, int offset) throws IOException {
        this.blockDevice = blockDevice;
        this.offset = offset;
        ByteBuffer byteBuffer = ByteBuffer.allocate(512);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(512)");
        this.buffer = byteBuffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.blockDevice.read(this.offset, this.buffer);
        this.buffer.clear();
        if (this.buffer.getInt(0) != 1096897106 || this.buffer.getInt(484) != 1631679090 || this.buffer.getInt(508) != -1437270016) {
            throw (Throwable)new IOException("invalid fs info structure!");
        }
    }

    static {
        Companion = new Companion(null);
        INVALID_VALUE = (int)0xFFFFFFFFL;
        String string = FsInfoStructure.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FsInfoStructure::class.java.simpleName");
        TAG = string;
    }

    public /* synthetic */ FsInfoStructure(BlockDeviceDriver blockDevice, int offset, DefaultConstructorMarker $constructor_marker) {
        this(blockDevice, offset);
    }

    public static final int getINVALID_VALUE() {
        Companion companion = Companion;
        return INVALID_VALUE;
    }

    public static final void setINVALID_VALUE(int n) {
        Companion companion = Companion;
        INVALID_VALUE = n;
    }

    @JvmStatic
    @NotNull
    public static final FsInfoStructure read(@NotNull BlockDeviceDriver blockDevice, int offset) throws IOException {
        return Companion.read(blockDevice, offset);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/FsInfoStructure$Companion;", "", "()V", "FREE_COUNT_OFF", "", "INVALID_VALUE", "INVALID_VALUE$annotations", "getINVALID_VALUE", "()I", "setINVALID_VALUE", "(I)V", "LEAD_SIGNATURE", "LEAD_SIGNATURE_OFF", "NEXT_FREE_OFFSET", "STRUCT_SIGNATURE", "STRUCT_SIGNATURE_OFF", "TAG", "", "TRAIL_SIGNATURE", "TRAIL_SIGNATURE_OFF", "read", "Lcom/github/mjdev/libaums/fs/fat32/FsInfoStructure;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "offset", "libaums_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void INVALID_VALUE$annotations() {
        }

        public final int getINVALID_VALUE() {
            return INVALID_VALUE;
        }

        public final void setINVALID_VALUE(int n) {
            INVALID_VALUE = n;
        }

        @JvmStatic
        @NotNull
        public final FsInfoStructure read(@NotNull BlockDeviceDriver blockDevice, int offset) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
            return new FsInfoStructure(blockDevice, offset, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

