/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemCreator;
import com.github.mjdev.libaums.fs.fat32.Fat32FileSystemCreator;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class FileSystemFactory {
    private static List<FileSystemCreator> fileSystems = new ArrayList<FileSystemCreator>();
    private static TimeZone timeZone = TimeZone.getDefault();

    public static FileSystem createFileSystem(PartitionTableEntry entry, BlockDeviceDriver blockDevice) throws IOException, UnsupportedFileSystemException {
        for (FileSystemCreator creator : fileSystems) {
            FileSystem fs = creator.read(entry, blockDevice);
            if (fs == null) continue;
            return fs;
        }
        throw new UnsupportedFileSystemException();
    }

    public static synchronized void registerFileSystem(FileSystemCreator creator) {
        fileSystems.add(creator);
    }

    public static void setTimeZone(TimeZone zone) {
        timeZone = zone;
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    static {
        FileSystemFactory.registerFileSystem(new Fat32FileSystemCreator());
    }

    public static class UnsupportedFileSystemException
    extends IOException {
    }
}

