/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;

public abstract class AbstractUsbFile
implements UsbFile {
    private static final String TAG = AbstractUsbFile.class.getSimpleName();

    @Override
    public UsbFile search(String path) throws IOException {
        int index;
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException("This is a file!");
        }
        Log.d((String)TAG, (String)("search file: " + path));
        if (this.isRoot() && path.equals("/")) {
            return this;
        }
        if (this.isRoot() && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.indexOf("/")) < 0) {
            Log.d((String)TAG, (String)("search entry: " + path));
            UsbFile file = this.searchThis(path);
            return file;
        }
        String subPath = path.substring(index + 1);
        String dirName = path.substring(0, index);
        Log.d((String)TAG, (String)("search recursively " + subPath + " in " + dirName));
        UsbFile file = this.searchThis(dirName);
        if (file != null && file.isDirectory()) {
            Log.d((String)TAG, (String)("found directory " + dirName));
            return file.search(subPath);
        }
        Log.d((String)TAG, (String)("not found " + path));
        return null;
    }

    private UsbFile searchThis(String name) throws IOException {
        for (UsbFile file : this.listFiles()) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    @Override
    public String getAbsolutePath() {
        if (this.isRoot()) {
            return "/";
        }
        if (this.getParent().isRoot()) {
            return "/" + this.getName();
        }
        return this.getParent().getAbsolutePath() + "/" + this.getName();
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        return obj instanceof UsbFile && this.getAbsolutePath().equals(((UsbFile)obj).getAbsolutePath());
    }
}

