/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.scsi.UnitNotReady;
import com.github.mjdev.libaums.driver.scsi.commands.CommandBlockWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.CommandStatusWrapper;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiry;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiInquiryResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiRead10;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacity;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiReadCapacityResponse;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiTestUnitReady;
import com.github.mjdev.libaums.driver.scsi.commands.ScsiWrite10;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000fH\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/mjdev/libaums/driver/scsi/ScsiBlockDevice;", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "usbCommunication", "Lcom/github/mjdev/libaums/usb/UsbCommunication;", "lun", "", "(Lcom/github/mjdev/libaums/usb/UsbCommunication;B)V", "<set-?>", "", "blockSize", "getBlockSize", "()I", "csw", "Lcom/github/mjdev/libaums/driver/scsi/commands/CommandStatusWrapper;", "cswBuffer", "Ljava/nio/ByteBuffer;", "lastBlockAddress", "outBuffer", "readCommand", "Lcom/github/mjdev/libaums/driver/scsi/commands/ScsiRead10;", "writeCommand", "Lcom/github/mjdev/libaums/driver/scsi/commands/ScsiWrite10;", "init", "", "read", "devOffset", "", "dest", "transferCommand", "", "command", "Lcom/github/mjdev/libaums/driver/scsi/commands/CommandBlockWrapper;", "inBuffer", "write", "src", "Companion", "libaums_release"})
public final class ScsiBlockDevice
implements BlockDeviceDriver {
    private final ByteBuffer outBuffer;
    private final ByteBuffer cswBuffer;
    private int blockSize;
    private int lastBlockAddress;
    private final ScsiWrite10 writeCommand;
    private final ScsiRead10 readCommand;
    private final CommandStatusWrapper csw;
    private final UsbCommunication usbCommunication;
    private final byte lun;
    private static final String TAG;
    public static final Companion Companion;

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void init() throws IOException {
        ByteBuffer inBuffer = ByteBuffer.allocate(36);
        ScsiInquiry inquiry = new ScsiInquiry((byte)inBuffer.array().length, this.lun);
        CommandBlockWrapper commandBlockWrapper = inquiry;
        ByteBuffer byteBuffer = inBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"inBuffer");
        this.transferCommand(commandBlockWrapper, byteBuffer);
        inBuffer.clear();
        ScsiInquiryResponse inquiryResponse = ScsiInquiryResponse.Companion.read(inBuffer);
        Log.d((String)TAG, (String)("inquiry response: " + inquiryResponse));
        if (inquiryResponse.getPeripheralQualifier() != 0 || inquiryResponse.getPeripheralDeviceType() != 0) {
            throw (Throwable)new IOException("unsupported PeripheralQualifier or PeripheralDeviceType");
        }
        ScsiTestUnitReady testUnit = new ScsiTestUnitReady(this.lun);
        try {
            CommandBlockWrapper commandBlockWrapper2 = testUnit;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"ByteBuffer.allocate(0)");
            if (!this.transferCommand(commandBlockWrapper2, byteBuffer2)) {
                Log.e((String)TAG, (String)"unit not ready!");
                throw (Throwable)new UnitNotReady();
            }
        }
        catch (IOException e) {
            if (StringsKt.equals$default((String)e.getMessage(), (String)"Unsuccessful Csw status: 1", (boolean)false, (int)2, null)) {
                throw (Throwable)new UnitNotReady();
            }
            throw (Throwable)e;
        }
        ScsiReadCapacity readCapacity = new ScsiReadCapacity(this.lun);
        inBuffer.clear();
        this.transferCommand(readCapacity, inBuffer);
        inBuffer.clear();
        ScsiReadCapacityResponse readCapacityResponse = ScsiReadCapacityResponse.Companion.read(inBuffer);
        this.blockSize = readCapacityResponse.getBlockLength();
        this.lastBlockAddress = readCapacityResponse.getLogicalBlockAddress();
        Log.i((String)TAG, (String)("Block size: " + this.getBlockSize()));
        Log.i((String)TAG, (String)("Last block address: " + this.lastBlockAddress));
    }

    private final boolean transferCommand(CommandBlockWrapper command, ByteBuffer inBuffer) throws IOException {
        byte[] outArray = this.outBuffer.array();
        Arrays.fill(outArray, (byte)0);
        this.outBuffer.clear();
        command.serialize(this.outBuffer);
        this.outBuffer.clear();
        int written = this.usbCommunication.bulkOutTransfer(this.outBuffer);
        if (written != outArray.length) {
            throw (Throwable)new IOException("Writing all bytes on command " + command + " failed!");
        }
        int transferLength = command.getdCbwDataTransferLength();
        int read = 0;
        if (transferLength > 0) {
            if (command.getDirection() == CommandBlockWrapper.Direction.IN) {
                while ((read += this.usbCommunication.bulkInTransfer(inBuffer)) < transferLength) {
                }
                if (read != transferLength) {
                    throw (Throwable)new IOException("Unexpected command size (" + read + ") on response to " + command);
                }
            } else {
                written = 0;
                while ((written += this.usbCommunication.bulkOutTransfer(inBuffer)) < transferLength) {
                }
                if (written != transferLength) {
                    throw (Throwable)new IOException("Could not write all bytes: " + command);
                }
            }
        }
        this.cswBuffer.clear();
        read = this.usbCommunication.bulkInTransfer(this.cswBuffer);
        if (read != CommandStatusWrapper.Companion.getSIZE()) {
            throw (Throwable)new IOException("Unexpected command size while expecting csw");
        }
        this.cswBuffer.clear();
        this.csw.read(this.cswBuffer);
        if (this.csw.getbCswStatus() != CommandStatusWrapper.Companion.getCOMMAND_PASSED()) {
            throw (Throwable)new IOException("Unsuccessful Csw status: " + this.csw.getbCswStatus());
        }
        if (this.csw.getdCswTag() != command.getdCbwTag()) {
            throw (Throwable)new IOException("wrong csw tag!");
        }
        return this.csw.getbCswStatus() == CommandStatusWrapper.Companion.getCOMMAND_PASSED();
    }

    @Override
    public synchronized void read(long devOffset, @NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        if (dest.remaining() % this.getBlockSize() != 0) {
            throw (Throwable)new IllegalArgumentException("dest.remaining() must be multiple of blockSize!");
        }
        this.readCommand.init((int)devOffset, dest.remaining(), this.getBlockSize());
        this.transferCommand(this.readCommand, dest);
        dest.position(dest.limit());
    }

    @Override
    public synchronized void write(long devOffset, @NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        if (src.remaining() % this.getBlockSize() != 0) {
            throw (Throwable)new IllegalArgumentException("src.remaining() must be multiple of blockSize!");
        }
        this.writeCommand.init((int)devOffset, src.remaining(), this.getBlockSize());
        this.transferCommand(this.writeCommand, src);
        src.position(src.limit());
    }

    public ScsiBlockDevice(@NotNull UsbCommunication usbCommunication, byte lun) {
        Intrinsics.checkParameterIsNotNull((Object)usbCommunication, (String)"usbCommunication");
        this.usbCommunication = usbCommunication;
        this.lun = lun;
        ByteBuffer byteBuffer = ByteBuffer.allocate(31);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(31)");
        this.outBuffer = byteBuffer;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(CommandStatusWrapper.Companion.getSIZE());
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"ByteBuffer.allocate(CommandStatusWrapper.SIZE)");
        this.cswBuffer = byteBuffer2;
        this.writeCommand = new ScsiWrite10(this.lun);
        this.readCommand = new ScsiRead10(this.lun);
        this.csw = new CommandStatusWrapper();
    }

    static {
        Companion = new Companion(null);
        TAG = ScsiBlockDevice.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/mjdev/libaums/driver/scsi/ScsiBlockDevice$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

