/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.file;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B#\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/mjdev/libaums/driver/file/FileBlockDeviceDriver;", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "file", "Ljava/io/File;", "byteOffset", "", "blockSize", "(Ljava/io/File;II)V", "url", "Ljava/net/URL;", "(Ljava/net/URL;II)V", "<set-?>", "getBlockSize", "()I", "Ljava/io/RandomAccessFile;", "init", "", "read", "deviceOffset", "", "buffer", "Ljava/nio/ByteBuffer;", "write", "libaums_release"})
public final class FileBlockDeviceDriver
implements BlockDeviceDriver {
    private RandomAccessFile file;
    private int blockSize;
    private int byteOffset;

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public void read(long deviceOffset, @NotNull ByteBuffer buffer) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.file.seek(deviceOffset * (long)this.getBlockSize() + (long)this.byteOffset);
        int read = this.file.read(buffer.array(), buffer.position(), buffer.remaining());
        buffer.position(buffer.position() + read);
    }

    @Override
    public void write(long deviceOffset, @NotNull ByteBuffer buffer) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.file.seek(deviceOffset * (long)this.getBlockSize() + (long)this.byteOffset);
        this.file.write(buffer.array(), buffer.position(), buffer.remaining());
        buffer.position(buffer.limit());
    }

    @JvmOverloads
    public FileBlockDeviceDriver(@NotNull File file, int byteOffset, int blockSize) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = new RandomAccessFile(file, "rw");
        this.blockSize = blockSize;
        this.byteOffset = byteOffset;
    }

    public /* synthetic */ FileBlockDeviceDriver(File file, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) throws FileNotFoundException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 512;
        }
        this(file, n, n2);
    }

    @JvmOverloads
    public FileBlockDeviceDriver(@NotNull File file, int byteOffset) throws FileNotFoundException {
        this(file, byteOffset, 0, 4, null);
    }

    @JvmOverloads
    public FileBlockDeviceDriver(@NotNull File file) throws FileNotFoundException {
        this(file, 0, 0, 6, null);
    }

    @JvmOverloads
    public FileBlockDeviceDriver(@NotNull URL url, int byteOffset, int blockSize) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.byteOffset = byteOffset;
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        File tempFile = File.createTempFile("libaums_file_blockdevice", ".bin");
        tempFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempFile);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        this.file = new RandomAccessFile(tempFile, "rw");
        this.blockSize = blockSize;
    }

    public /* synthetic */ FileBlockDeviceDriver(URL uRL, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 512;
        }
        this(uRL, n, n2);
    }

    @JvmOverloads
    public FileBlockDeviceDriver(@NotNull URL url, int byteOffset) throws IOException {
        this(url, byteOffset, 0, 4, null);
    }

    @JvmOverloads
    public FileBlockDeviceDriver(@NotNull URL url) throws IOException {
        this(url, 0, 0, 6, null);
    }
}

