/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.ByteBlockDevice;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemFactory;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;

public class Partition
extends ByteBlockDevice {
    private static final String TAG = Partition.class.getSimpleName();
    private FileSystem fileSystem;

    private Partition(BlockDeviceDriver blockDevice, PartitionTableEntry entry) {
        super(blockDevice, entry.getLogicalBlockAddress());
    }

    public static Partition createPartition(PartitionTableEntry entry, BlockDeviceDriver blockDevice) throws IOException {
        try {
            FileSystem fs;
            Partition partition = new Partition(blockDevice, entry);
            partition.fileSystem = fs = FileSystemFactory.createFileSystem(entry, partition);
            return partition;
        }
        catch (FileSystemFactory.UnsupportedFileSystemException e) {
            Log.w((String)TAG, (String)"Unsupported fs on partition");
            return null;
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getVolumeLabel() {
        return this.fileSystem.getVolumeLabel();
    }
}

