/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.fs.fat32.FatDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.ShortName;
import java.nio.ByteBuffer;
import java.util.List;

class FatLfnDirectoryEntry {
    private FatDirectoryEntry actualEntry;
    private String lfnName;

    private FatLfnDirectoryEntry() {
    }

    private FatLfnDirectoryEntry(FatDirectoryEntry actualEntry, String lfnName) {
        this.actualEntry = actualEntry;
        this.lfnName = lfnName;
    }

    static FatLfnDirectoryEntry createNew(String name, ShortName shortName) {
        FatLfnDirectoryEntry result = new FatLfnDirectoryEntry();
        result.lfnName = name;
        result.actualEntry = FatDirectoryEntry.createNew();
        result.actualEntry.setShortName(shortName);
        return result;
    }

    static FatLfnDirectoryEntry read(FatDirectoryEntry actualEntry, List<FatDirectoryEntry> lfnParts) {
        StringBuilder builder = new StringBuilder(13 * lfnParts.size());
        if (lfnParts.size() > 0) {
            for (int i = lfnParts.size() - 1; i >= 0; --i) {
                lfnParts.get(i).extractLfnPart(builder);
            }
            return new FatLfnDirectoryEntry(actualEntry, builder.toString());
        }
        return new FatLfnDirectoryEntry(actualEntry, null);
    }

    void serialize(ByteBuffer buffer) {
        if (this.lfnName != null) {
            byte checksum = this.actualEntry.getShortName().calculateCheckSum();
            int entrySize = this.getEntryCount();
            int index = entrySize - 2;
            FatDirectoryEntry entry = FatDirectoryEntry.createLfnPart(this.lfnName, index * 13, checksum, index + 1, true);
            entry.serialize(buffer);
            while (index-- > 0) {
                entry = FatDirectoryEntry.createLfnPart(this.lfnName, index * 13, checksum, index + 1, false);
                entry.serialize(buffer);
            }
        }
        this.actualEntry.serialize(buffer);
    }

    int getEntryCount() {
        int result = 1;
        if (this.lfnName != null) {
            int len = this.lfnName.length();
            result += len / 13;
            if (len % 13 != 0) {
                ++result;
            }
        }
        return result;
    }

    String getName() {
        String sname;
        if (this.lfnName != null) {
            return this.lfnName;
        }
        String name = sname = this.actualEntry.getShortName().getString();
        String ext = "";
        String[] split = sname.split(".");
        if (split.length == 2) {
            name = split[0];
            ext = split[0];
        }
        if (this.actualEntry.isShortNameLowerCase()) {
            name = name.toLowerCase();
        }
        if (this.actualEntry.isShortNameExtLowerCase()) {
            ext = ext.toLowerCase();
        }
        if (!ext.isEmpty()) {
            name = name + "." + ext;
        }
        return name;
    }

    void setName(String newName, ShortName shortName) {
        this.lfnName = newName;
        this.actualEntry.setShortName(shortName);
    }

    long getFileSize() {
        return this.actualEntry.getFileSize();
    }

    void setFileSize(long newSize) {
        this.actualEntry.setFileSize(newSize);
    }

    long getStartCluster() {
        return this.actualEntry.getStartCluster();
    }

    void setStartCluster(long newStartCluster) {
        this.actualEntry.setStartCluster(newStartCluster);
    }

    void setLastAccessedTimeToNow() {
        this.actualEntry.setLastAccessedDateTime(System.currentTimeMillis());
    }

    void setLastModifiedTimeToNow() {
        this.actualEntry.setLastModifiedDateTime(System.currentTimeMillis());
    }

    boolean isDirectory() {
        return this.actualEntry.isDirectory();
    }

    void setDirectory() {
        this.actualEntry.setDirectory();
    }

    FatDirectoryEntry getActualEntry() {
        return this.actualEntry;
    }

    static void copyDateTime(FatLfnDirectoryEntry from, FatLfnDirectoryEntry to) {
        FatDirectoryEntry actualFrom = from.getActualEntry();
        FatDirectoryEntry actualTo = from.getActualEntry();
        actualTo.setCreatedDateTime(actualFrom.getCreatedDateTime());
        actualTo.setLastAccessedDateTime(actualFrom.getLastAccessedDateTime());
        actualTo.setLastModifiedDateTime(actualFrom.getLastModifiedDateTime());
    }

    public String toString() {
        return "[FatLfnDirectoryEntry getName()=" + this.getName() + "]";
    }
}

