/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBlockDevice
implements BlockDeviceDriver {
    private static final String TAG = ByteBlockDevice.class.getSimpleName();
    private BlockDeviceDriver targetBlockDevice;
    private int logicalOffsetToAdd;
    private int blockSize;

    public ByteBlockDevice(BlockDeviceDriver targetBlockDevice, int logicalOffsetToAdd) {
        this.targetBlockDevice = targetBlockDevice;
        this.blockSize = targetBlockDevice.getBlockSize();
        this.logicalOffsetToAdd = logicalOffsetToAdd;
    }

    public ByteBlockDevice(BlockDeviceDriver targetBlockDevice) {
        this(targetBlockDevice, 0);
    }

    @Override
    public void init() throws IOException {
        this.targetBlockDevice.init();
    }

    @Override
    public void read(long byteOffset, ByteBuffer dest) throws IOException {
        long devOffset = byteOffset / (long)this.blockSize + (long)this.logicalOffsetToAdd;
        if (byteOffset % (long)this.blockSize != 0L) {
            ByteBuffer tmp = ByteBuffer.allocate(this.blockSize);
            this.targetBlockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(byteOffset % (long)this.blockSize));
            int limit = Math.min(dest.remaining(), tmp.remaining());
            tmp.limit(tmp.position() + limit);
            dest.put(tmp);
            ++devOffset;
        }
        if (dest.remaining() > 0) {
            ByteBuffer buffer;
            if (dest.remaining() % this.blockSize != 0) {
                int rounded = this.blockSize - dest.remaining() % this.blockSize + dest.remaining();
                buffer = ByteBuffer.allocate(rounded);
                buffer.limit(rounded);
            } else {
                buffer = dest;
            }
            this.targetBlockDevice.read(devOffset, buffer);
            if (dest.remaining() % this.blockSize != 0) {
                System.arraycopy(buffer.array(), 0, dest.array(), dest.position(), dest.remaining());
            }
            dest.position(dest.limit());
        }
    }

    @Override
    public void write(long byteOffset, ByteBuffer src) throws IOException {
        long devOffset = byteOffset / (long)this.blockSize + (long)this.logicalOffsetToAdd;
        if (byteOffset % (long)this.blockSize != 0L) {
            ByteBuffer tmp = ByteBuffer.allocate(this.blockSize);
            this.targetBlockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(byteOffset % (long)this.blockSize));
            int remaining = Math.min(tmp.remaining(), src.remaining());
            tmp.put(src.array(), src.position(), remaining);
            src.position(src.position() + remaining);
            tmp.clear();
            this.targetBlockDevice.write(devOffset, tmp);
            ++devOffset;
        }
        if (src.remaining() > 0) {
            ByteBuffer buffer;
            if (src.remaining() % this.blockSize != 0) {
                int rounded = this.blockSize - src.remaining() % this.blockSize + src.remaining();
                buffer = ByteBuffer.allocate(rounded);
                buffer.limit(rounded);
                System.arraycopy(src.array(), src.position(), buffer.array(), 0, src.remaining());
                src.position(src.limit());
            } else {
                buffer = src;
            }
            this.targetBlockDevice.write(devOffset, buffer);
        }
    }

    @Override
    public int getBlockSize() {
        return this.targetBlockDevice.getBlockSize();
    }
}

