/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.os.Build;
import android.util.Log;
import com.github.mjdev.libaums.usb.HoneyCombMr1Communication;
import com.github.mjdev.libaums.usb.JellyBeanMr2Communication;
import com.github.mjdev.libaums.usb.UsbCommunication;
import com.github.mjdev.libaums.usb.UsbRequestCommunication;

public class UsbCommunicationFactory {
    private static final String TAG = UsbCommunicationFactory.class.getSimpleName();
    private static UnderlyingUsbCommunication underlyingUsbCommunication = UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC;

    public static UsbCommunication createUsbCommunication(UsbDeviceConnection deviceConnection, UsbEndpoint outEndpoint, UsbEndpoint inEndpoint) {
        UsbCommunication communication;
        if (underlyingUsbCommunication == UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC) {
            if (Build.VERSION.SDK_INT >= 18) {
                communication = new JellyBeanMr2Communication(deviceConnection, outEndpoint, inEndpoint);
            } else {
                Log.i((String)TAG, (String)"using workaround usb communication");
                communication = new HoneyCombMr1Communication(deviceConnection, outEndpoint, inEndpoint);
            }
        } else {
            communication = new UsbRequestCommunication(deviceConnection, outEndpoint, inEndpoint);
        }
        return communication;
    }

    public static void setUnderlyingUsbCommunication(UnderlyingUsbCommunication underlyingUsbCommunication) {
        UsbCommunicationFactory.underlyingUsbCommunication = underlyingUsbCommunication;
    }

    static enum UnderlyingUsbCommunication {
        USB_REQUEST_ASYNC,
        DEVICE_CONNECTION_SYNC;

    }
}

