/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.Fat32FileSystemCreator;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemCreator;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileSystemFactory {
    private static List<FileSystemCreator> fileSystems = new ArrayList<FileSystemCreator>();

    public static FileSystem createFileSystem(PartitionTableEntry entry, BlockDeviceDriver blockDevice) throws IOException, UnsupportedFileSystemException {
        for (FileSystemCreator creator : fileSystems) {
            FileSystem fs = creator.read(entry, blockDevice);
            if (fs == null) continue;
            return fs;
        }
        throw new UnsupportedFileSystemException();
    }

    public static synchronized void registerFileSystem(FileSystemCreator creator) {
        fileSystems.add(creator);
    }

    static {
        FileSystemFactory.registerFileSystem(new Fat32FileSystemCreator());
    }

    public static class UnsupportedFileSystemException
    extends Exception {
    }
}

