/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.ClusterChain;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.FatFile;
import com.github.mjdev.libaums.fs.fat32.FatLfnDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.ShortName;
import com.github.mjdev.libaums.fs.fat32.ShortNameGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FatDirectory
implements UsbFile {
    private static String TAG = FatDirectory.class.getSimpleName();
    private ClusterChain chain;
    private BlockDeviceDriver blockDevice;
    private FAT fat;
    private Fat32BootSector bootSector;
    private List<FatLfnDirectoryEntry> entries;
    private Map<String, FatLfnDirectoryEntry> lfnMap;
    private Map<ShortName, FatDirectoryEntry> shortNameMap;
    private FatDirectory parent;
    private FatLfnDirectoryEntry entry;
    private String volumeLabel;
    private boolean hasBeenInited;

    private FatDirectory(BlockDeviceDriver blockDevice, FAT fat, Fat32BootSector bootSector, FatDirectory parent) {
        this.blockDevice = blockDevice;
        this.fat = fat;
        this.bootSector = bootSector;
        this.parent = parent;
        this.lfnMap = new HashMap<String, FatLfnDirectoryEntry>();
        this.shortNameMap = new HashMap<ShortName, FatDirectoryEntry>();
    }

    static FatDirectory create(FatLfnDirectoryEntry entry, BlockDeviceDriver blockDevice, FAT fat, Fat32BootSector bootSector, FatDirectory parent) {
        FatDirectory result = new FatDirectory(blockDevice, fat, bootSector, parent);
        result.entry = entry;
        return result;
    }

    static FatDirectory readRoot(BlockDeviceDriver blockDevice, FAT fat, Fat32BootSector bootSector) throws IOException {
        FatDirectory result = new FatDirectory(blockDevice, fat, bootSector, null);
        result.chain = new ClusterChain(bootSector.getRootDirStartCluster(), blockDevice, fat, bootSector);
        result.init();
        return result;
    }

    private void init() throws IOException {
        if (this.chain == null) {
            this.chain = new ClusterChain(this.entry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
        if (this.entries == null) {
            this.entries = new ArrayList<FatLfnDirectoryEntry>();
        }
        if (this.entries.size() == 0 && !this.hasBeenInited) {
            this.readEntries();
        }
        this.hasBeenInited = true;
    }

    private void readEntries() throws IOException {
        FatDirectoryEntry e;
        ByteBuffer buffer = ByteBuffer.allocate((int)this.chain.getLength());
        this.chain.read(0L, buffer);
        ArrayList<FatDirectoryEntry> list = new ArrayList<FatDirectoryEntry>();
        buffer.flip();
        while (buffer.remaining() > 0 && (e = FatDirectoryEntry.read(buffer)) != null) {
            if (e.isLfnEntry()) {
                list.add(e);
                continue;
            }
            if (e.isVolumeLabel()) {
                if (!this.isRoot()) {
                    Log.w((String)TAG, (String)"volume label in non root dir!");
                }
                this.volumeLabel = e.getVolumeLabel();
                Log.d((String)TAG, (String)("volume label: " + this.volumeLabel));
                continue;
            }
            if (e.isDeleted()) {
                list.clear();
                continue;
            }
            FatLfnDirectoryEntry lfnEntry = FatLfnDirectoryEntry.read(e, list);
            this.addEntry(lfnEntry, e);
            list.clear();
        }
    }

    private void addEntry(FatLfnDirectoryEntry lfnEntry, FatDirectoryEntry entry) {
        this.entries.add(lfnEntry);
        this.lfnMap.put(lfnEntry.getName().toLowerCase(Locale.getDefault()), lfnEntry);
        this.shortNameMap.put(entry.getShortName(), entry);
    }

    void removeEntry(FatLfnDirectoryEntry lfnEntry) {
        this.entries.remove(lfnEntry);
        this.lfnMap.remove(lfnEntry.getName().toLowerCase(Locale.getDefault()));
        this.shortNameMap.remove(lfnEntry.getActualEntry().getShortName());
    }

    void renameEntry(FatLfnDirectoryEntry lfnEntry, String newName) throws IOException {
        if (lfnEntry.getName().equals(newName)) {
            return;
        }
        this.removeEntry(lfnEntry);
        lfnEntry.setName(newName, ShortNameGenerator.generateShortName(newName, this.shortNameMap.keySet()));
        this.addEntry(lfnEntry, lfnEntry.getActualEntry());
        this.write();
    }

    void write() throws IOException {
        this.init();
        boolean writeVolumeLabel = this.isRoot() && this.volumeLabel != null;
        int totalEntryCount = 0;
        for (FatLfnDirectoryEntry entry : this.entries) {
            totalEntryCount += entry.getEntryCount();
        }
        if (writeVolumeLabel) {
            ++totalEntryCount;
        }
        long totalBytes = totalEntryCount * 32;
        this.chain.setLength(totalBytes);
        ByteBuffer buffer = ByteBuffer.allocate((int)this.chain.getLength());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (writeVolumeLabel) {
            FatDirectoryEntry.createVolumeLabel(this.volumeLabel).serialize(buffer);
        }
        for (FatLfnDirectoryEntry entry : this.entries) {
            entry.serialize(buffer);
        }
        if (totalBytes % (long)this.bootSector.getBytesPerCluster() != 0L || totalBytes == 0L) {
            buffer.put(new byte[32]);
        }
        buffer.flip();
        this.chain.write(0L, buffer);
    }

    @Override
    public boolean isRoot() {
        return this.entry == null;
    }

    String getVolumeLabel() {
        return this.volumeLabel;
    }

    @Override
    public FatFile createFile(String name) throws IOException {
        if (this.lfnMap.containsKey(name.toLowerCase(Locale.getDefault()))) {
            throw new IOException("Item already exists!");
        }
        this.init();
        ShortName shortName = ShortNameGenerator.generateShortName(name, this.shortNameMap.keySet());
        FatLfnDirectoryEntry entry = FatLfnDirectoryEntry.createNew(name, shortName);
        long newStartCluster = this.fat.alloc(new Long[0], 1)[0];
        entry.setStartCluster(newStartCluster);
        Log.d((String)TAG, (String)("adding entry: " + entry + " with short name: " + shortName));
        this.addEntry(entry, entry.getActualEntry());
        this.write();
        return FatFile.create(entry, this.blockDevice, this.fat, this.bootSector, this);
    }

    @Override
    public FatDirectory createDirectory(String name) throws IOException {
        if (this.lfnMap.containsKey(name.toLowerCase(Locale.getDefault()))) {
            throw new IOException("Item already exists!");
        }
        this.init();
        ShortName shortName = ShortNameGenerator.generateShortName(name, this.shortNameMap.keySet());
        FatLfnDirectoryEntry entry = FatLfnDirectoryEntry.createNew(name, shortName);
        entry.setDirectory();
        long newStartCluster = this.fat.alloc(new Long[0], 1)[0];
        entry.setStartCluster(newStartCluster);
        Log.d((String)TAG, (String)("adding entry: " + entry + " with short name: " + shortName));
        this.addEntry(entry, entry.getActualEntry());
        this.write();
        FatDirectory result = FatDirectory.create(entry, this.blockDevice, this.fat, this.bootSector, this);
        result.hasBeenInited = true;
        result.entries = new ArrayList<FatLfnDirectoryEntry>();
        FatLfnDirectoryEntry dotEntry = FatLfnDirectoryEntry.createNew(null, new ShortName(".", ""));
        dotEntry.setDirectory();
        dotEntry.setStartCluster(newStartCluster);
        FatLfnDirectoryEntry.copyDateTime(entry, dotEntry);
        result.addEntry(dotEntry, dotEntry.getActualEntry());
        FatLfnDirectoryEntry dotDotEntry = FatLfnDirectoryEntry.createNew(null, new ShortName("..", ""));
        dotDotEntry.setDirectory();
        dotDotEntry.setStartCluster(this.isRoot() ? 0L : entry.getStartCluster());
        FatLfnDirectoryEntry.copyDateTime(entry, dotDotEntry);
        result.addEntry(dotDotEntry, dotDotEntry.getActualEntry());
        result.write();
        return result;
    }

    @Override
    public void setLength(long newLength) {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public long getLength() {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public UsbFile search(String path) throws IOException {
        Log.d((String)TAG, (String)("search file: " + path));
        this.init();
        int index = path.indexOf("/");
        if (index < 0) {
            Log.d((String)TAG, (String)("search entry: " + path));
            FatLfnDirectoryEntry entry = this.findEntry(path);
            if (entry != null) {
                if (entry.isDirectory()) {
                    return FatDirectory.create(entry, this.blockDevice, this.fat, this.bootSector, this);
                }
                return FatFile.create(entry, this.blockDevice, this.fat, this.bootSector, this);
            }
        } else {
            String subPath = path.substring(index + 1);
            String dirName = path.substring(0, index);
            Log.d((String)TAG, (String)("search recursively " + subPath + " in " + dirName));
            for (FatLfnDirectoryEntry entry : this.entries) {
                if (!entry.isDirectory() || !entry.getName().equals(dirName)) continue;
                Log.d((String)TAG, (String)("found " + dirName));
                FatDirectory dir = FatDirectory.create(entry, this.blockDevice, this.fat, this.bootSector, this);
                return dir.search(subPath);
            }
        }
        Log.d((String)TAG, (String)("not found " + path));
        return null;
    }

    private FatLfnDirectoryEntry findEntry(String name) {
        for (FatLfnDirectoryEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public String getName() {
        return this.entry != null ? this.entry.getName() : "";
    }

    @Override
    public void setName(String newName) throws IOException {
        if (this.isRoot()) {
            throw new IllegalStateException("Cannot rename root dir!");
        }
        this.parent.renameEntry(this.entry, newName);
    }

    @Override
    public long createdAt() {
        if (this.isRoot()) {
            throw new IllegalStateException("root dir!");
        }
        return this.entry.getActualEntry().getCreatedDateTime();
    }

    @Override
    public long lastModified() {
        if (this.isRoot()) {
            throw new IllegalStateException("root dir!");
        }
        return this.entry.getActualEntry().getLastModifiedDateTime();
    }

    @Override
    public long lastAccessed() {
        if (this.isRoot()) {
            throw new IllegalStateException("root dir!");
        }
        return this.entry.getActualEntry().getLastAccessedDateTime();
    }

    @Override
    public UsbFile getParent() {
        return this.parent;
    }

    @Override
    public String[] list() throws IOException {
        this.init();
        ArrayList<String> list = new ArrayList<String>(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            String name = this.entries.get(i).getName();
            if (name.equals(".") || name.equals("..")) continue;
            list.add(name);
        }
        String[] array = new String[list.size()];
        array = list.toArray(array);
        return array;
    }

    @Override
    public UsbFile[] listFiles() throws IOException {
        this.init();
        ArrayList<UsbFile> list = new ArrayList<UsbFile>(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            FatLfnDirectoryEntry entry = this.entries.get(i);
            String name = entry.getName();
            if (name.equals(".") || name.equals("..")) continue;
            if (entry.isDirectory()) {
                list.add(FatDirectory.create(entry, this.blockDevice, this.fat, this.bootSector, this));
                continue;
            }
            list.add(FatFile.create(entry, this.blockDevice, this.fat, this.bootSector, this));
        }
        UsbFile[] array = new UsbFile[list.size()];
        array = list.toArray(array);
        return array;
    }

    @Override
    public void read(long offset, ByteBuffer destination) throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void write(long offset, ByteBuffer source) throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void moveTo(UsbFile destination) throws IOException {
        if (this.isRoot()) {
            throw new IllegalStateException("cannot move root dir!");
        }
        if (!destination.isDirectory()) {
            throw new IllegalStateException("destination cannot be a file!");
        }
        if (!(destination instanceof FatDirectory)) {
            throw new IllegalStateException("cannot move between different filesystems!");
        }
        FatDirectory destinationDir = (FatDirectory)destination;
        if (destinationDir.lfnMap.containsKey(this.entry.getName().toLowerCase(Locale.getDefault()))) {
            throw new IOException("item already exists in destination!");
        }
        this.init();
        destinationDir.init();
        this.parent.removeEntry(this.entry);
        destinationDir.addEntry(this.entry, this.entry.getActualEntry());
        this.parent.write();
        destinationDir.write();
        this.parent = destinationDir;
    }

    void move(FatLfnDirectoryEntry entry, UsbFile destination) throws IOException {
        if (!destination.isDirectory()) {
            throw new IllegalStateException("destination cannot be a file!");
        }
        if (!(destination instanceof FatDirectory)) {
            throw new IllegalStateException("cannot move between different filesystems!");
        }
        FatDirectory destinationDir = (FatDirectory)destination;
        if (destinationDir.lfnMap.containsKey(entry.getName().toLowerCase(Locale.getDefault()))) {
            throw new IOException("item already exists in destination!");
        }
        this.init();
        destinationDir.init();
        this.removeEntry(entry);
        destinationDir.addEntry(entry, entry.getActualEntry());
        this.write();
        destinationDir.write();
    }

    @Override
    public void delete() throws IOException {
        UsbFile[] subElements;
        if (this.isRoot()) {
            throw new IllegalStateException("Root dir cannot be deleted!");
        }
        this.init();
        for (UsbFile file : subElements = this.listFiles()) {
            file.delete();
        }
        this.parent.removeEntry(this.entry);
        this.parent.write();
        this.chain.setLength(0L);
    }
}

