/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import com.github.mjdev.libaums.UsbCommunication;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.BlockDeviceDriverFactory;
import com.github.mjdev.libaums.partition.Partition;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import com.github.mjdev.libaums.partition.PartitionTableFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UsbMassStorageDevice {
    private static final String TAG = UsbMassStorageDevice.class.getSimpleName();
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;
    private static int TRANSFER_TIMEOUT = 21000;
    private UsbManager usbManager;
    private UsbDeviceConnection deviceConnection;
    private UsbDevice usbDevice;
    private UsbInterface usbInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private BlockDeviceDriver blockDevice;
    private PartitionTable partitionTable;
    private List<Partition> partitions = new ArrayList<Partition>();

    private UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.inEndpoint = inEndpoint;
        this.outEndpoint = outEndpoint;
    }

    public static UsbMassStorageDevice[] getMassStorageDevices(Context context) {
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        ArrayList<UsbMassStorageDevice> result = new ArrayList<UsbMassStorageDevice>();
        for (UsbDevice device : usbManager.getDeviceList().values()) {
            Log.i((String)TAG, (String)("found usb device: " + device));
            int interfaceCount = device.getInterfaceCount();
            for (int i = 0; i < interfaceCount; ++i) {
                UsbInterface usbInterface = device.getInterface(i);
                Log.i((String)TAG, (String)("found usb interface: " + usbInterface));
                if (usbInterface.getInterfaceClass() != 8 || usbInterface.getInterfaceSubclass() != 6 || usbInterface.getInterfaceProtocol() != 80) {
                    Log.i((String)TAG, (String)"device interface not suitable!");
                    continue;
                }
                int endpointCount = usbInterface.getEndpointCount();
                if (endpointCount != 2) {
                    Log.w((String)TAG, (String)"inteface endpoint count != 2");
                }
                UsbEndpoint outEndpoint = null;
                UsbEndpoint inEndpoint = null;
                for (int j = 0; j < endpointCount; ++j) {
                    UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                    Log.i((String)TAG, (String)("found usb endpoint: " + endpoint));
                    if (endpoint.getType() != 2) continue;
                    if (endpoint.getDirection() == 0) {
                        outEndpoint = endpoint;
                        continue;
                    }
                    inEndpoint = endpoint;
                }
                if (outEndpoint == null || inEndpoint == null) {
                    Log.e((String)TAG, (String)"Not all needed endpoints found!");
                    continue;
                }
                result.add(new UsbMassStorageDevice(usbManager, device, usbInterface, inEndpoint, outEndpoint));
            }
        }
        return result.toArray(new UsbMassStorageDevice[0]);
    }

    public void init() throws IOException {
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            throw new IllegalStateException("Missing permission to access usb device: " + this.usbDevice);
        }
        this.setupDevice();
    }

    private void setupDevice() throws IOException {
        UsbCommunication communication;
        Log.d((String)TAG, (String)"setup device");
        this.deviceConnection = this.usbManager.openDevice(this.usbDevice);
        if (this.deviceConnection == null) {
            Log.e((String)TAG, (String)"deviceConnetion is null!");
            return;
        }
        boolean claim = this.deviceConnection.claimInterface(this.usbInterface, true);
        if (!claim) {
            Log.e((String)TAG, (String)"could not claim interface!");
            return;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            communication = new JellyBeanMr2Communication();
        } else {
            Log.i((String)TAG, (String)"using workaround usb communication");
            communication = new HoneyCombMr1Communication();
        }
        this.blockDevice = BlockDeviceDriverFactory.createBlockDevice(communication);
        this.blockDevice.init();
        this.partitionTable = PartitionTableFactory.createPartitionTable(this.blockDevice);
        this.initPartitions();
    }

    private void initPartitions() throws IOException {
        Collection<PartitionTableEntry> partitionEntrys = this.partitionTable.getPartitionTableEntries();
        for (PartitionTableEntry entry : partitionEntrys) {
            Partition partition = Partition.createPartition(entry, this.blockDevice);
            if (partition == null) continue;
            this.partitions.add(partition);
        }
    }

    public void close() {
        Log.d((String)TAG, (String)"close device");
        if (this.deviceConnection == null) {
            return;
        }
        boolean release = this.deviceConnection.releaseInterface(this.usbInterface);
        if (!release) {
            Log.e((String)TAG, (String)"could not release interface!");
        }
        this.deviceConnection.close();
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    private class HoneyCombMr1Communication
    implements UsbCommunication {
        private HoneyCombMr1Communication() {
        }

        @Override
        public int bulkOutTransfer(byte[] buffer, int length) {
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.outEndpoint, buffer, length, TRANSFER_TIMEOUT);
        }

        @Override
        public int bulkOutTransfer(byte[] buffer, int offset, int length) {
            if (offset == 0) {
                return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.outEndpoint, buffer, length, TRANSFER_TIMEOUT);
            }
            byte[] tmpBuffer = new byte[length];
            System.arraycopy(buffer, offset, tmpBuffer, 0, length);
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.outEndpoint, tmpBuffer, length, TRANSFER_TIMEOUT);
        }

        @Override
        public int bulkInTransfer(byte[] buffer, int length) {
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.inEndpoint, buffer, length, TRANSFER_TIMEOUT);
        }

        @Override
        public int bulkInTransfer(byte[] buffer, int offset, int length) {
            if (offset == 0) {
                return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.inEndpoint, buffer, length, TRANSFER_TIMEOUT);
            }
            byte[] tmpBuffer = new byte[length];
            int result = UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.inEndpoint, tmpBuffer, length, TRANSFER_TIMEOUT);
            System.arraycopy(tmpBuffer, 0, buffer, offset, length);
            return result;
        }
    }

    @TargetApi(value=18)
    private class JellyBeanMr2Communication
    implements UsbCommunication {
        private JellyBeanMr2Communication() {
        }

        @Override
        public int bulkOutTransfer(byte[] buffer, int length) {
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.outEndpoint, buffer, length, TRANSFER_TIMEOUT);
        }

        @Override
        public int bulkOutTransfer(byte[] buffer, int offset, int length) {
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.outEndpoint, buffer, offset, length, TRANSFER_TIMEOUT);
        }

        @Override
        public int bulkInTransfer(byte[] buffer, int length) {
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.inEndpoint, buffer, length, TRANSFER_TIMEOUT);
        }

        @Override
        public int bulkInTransfer(byte[] buffer, int offset, int length) {
            return UsbMassStorageDevice.this.deviceConnection.bulkTransfer(UsbMassStorageDevice.this.inEndpoint, buffer, offset, length, TRANSFER_TIMEOUT);
        }
    }
}

