/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.fs.fat32.ShortName;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Calendar;

class FatDirectoryEntry {
    static final int SIZE = 32;
    private static final int ATTR_OFF = 11;
    private static final int FILE_SIZE_OFF = 28;
    private static final int MSB_CLUSTER_OFF = 20;
    private static final int LSB_CLUSTER_OFF = 26;
    private static final int CREATED_DATE_OFF = 16;
    private static final int CREATED_TIME_OFF = 14;
    private static final int LAST_WRITE_DATE_OFF = 24;
    private static final int LAST_WRITE_TIME_OFF = 22;
    private static final int LAST_ACCESSED_DATE_OFF = 18;
    private static final int FLAG_READONLY = 1;
    private static final int FLAG_HIDDEN = 2;
    private static final int FLAG_SYSTEM = 4;
    private static final int FLAG_VOLUME_ID = 8;
    private static final int FLAG_DIRECTORY = 16;
    private static final int FLAG_ARCHIVE = 32;
    static final int ENTRY_DELETED = 229;
    private ByteBuffer data;
    private ShortName shortName;

    private FatDirectoryEntry() {
    }

    private FatDirectoryEntry(ByteBuffer data) {
        this.data = data;
        data.order(ByteOrder.LITTLE_ENDIAN);
        this.shortName = ShortName.parse(data);
        data.clear();
    }

    static FatDirectoryEntry createNew() {
        FatDirectoryEntry result = new FatDirectoryEntry();
        result.data = ByteBuffer.allocate(32);
        long now = System.currentTimeMillis();
        result.setCreatedDateTime(now);
        result.setLastAccessedDateTime(now);
        result.setLastModifiedDateTime(now);
        return result;
    }

    static FatDirectoryEntry read(ByteBuffer data) {
        byte[] buffer = new byte[32];
        if (data.get(data.position()) == 0) {
            return null;
        }
        data.get(buffer);
        return new FatDirectoryEntry(ByteBuffer.wrap(buffer));
    }

    void serialize(ByteBuffer buffer) {
        buffer.put(this.data.array());
    }

    private int getFlags() {
        return this.data.get(11);
    }

    private void setFlag(int flag) {
        int flags = this.getFlags();
        this.data.put(11, (byte)(flag | flags));
    }

    private boolean isFlagSet(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    boolean isLfnEntry() {
        return this.isHidden() && this.isVolume() && this.isReadOnly() && this.isSystem();
    }

    boolean isDirectory() {
        return (this.getFlags() & 0x18) == 16;
    }

    void setDirectory() {
        this.setFlag(16);
    }

    boolean isVolumeLabel() {
        if (this.isLfnEntry()) {
            return false;
        }
        return (this.getFlags() & 0x18) == 8;
    }

    boolean isSystem() {
        return this.isFlagSet(4);
    }

    boolean isHidden() {
        return this.isFlagSet(2);
    }

    boolean isArchive() {
        return this.isFlagSet(32);
    }

    boolean isReadOnly() {
        return this.isFlagSet(1);
    }

    boolean isVolume() {
        return this.isFlagSet(8);
    }

    boolean isDeleted() {
        return this.getUnsignedInt8(0) == 229;
    }

    long getCreatedDateTime() {
        return FatDirectoryEntry.decodeDateTime(this.getUnsignedInt16(16), this.getUnsignedInt16(14));
    }

    void setCreatedDateTime(long dateTime) {
        this.setUnsignedInt16(16, FatDirectoryEntry.encodeDate(dateTime));
        this.setUnsignedInt16(14, FatDirectoryEntry.encodeTime(dateTime));
    }

    long getLastAccessedDateTime() {
        return FatDirectoryEntry.decodeDateTime(this.getUnsignedInt16(24), this.getUnsignedInt16(22));
    }

    void setLastAccessedDateTime(long dateTime) {
        this.setUnsignedInt16(24, FatDirectoryEntry.encodeDate(dateTime));
        this.setUnsignedInt16(22, FatDirectoryEntry.encodeTime(dateTime));
    }

    long getLastModifiedDateTime() {
        return FatDirectoryEntry.decodeDateTime(this.getUnsignedInt16(18), 0);
    }

    void setLastModifiedDateTime(long dateTime) {
        this.setUnsignedInt16(18, FatDirectoryEntry.encodeDate(dateTime));
    }

    ShortName getShortName() {
        if (this.data.get(0) == 0) {
            return null;
        }
        return this.shortName;
    }

    void setShortName(ShortName shortName) {
        this.shortName = shortName;
        shortName.serialize(this.data);
        this.data.clear();
    }

    static FatDirectoryEntry createVolumeLabel(String volumeLabel) {
        FatDirectoryEntry result = new FatDirectoryEntry();
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(volumeLabel.getBytes(Charset.forName("ASCII")), 0, buffer.array(), 0, volumeLabel.length());
        result.data = buffer;
        result.setFlag(8);
        return result;
    }

    String getVolumeLabel() {
        byte b;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 11 && (b = this.data.get(i)) != 0; ++i) {
            builder.append((char)b);
        }
        return builder.toString();
    }

    long getStartCluster() {
        int msb = this.getUnsignedInt16(20);
        int lsb = this.getUnsignedInt16(26);
        return msb << 16 | lsb;
    }

    void setStartCluster(long newStartCluster) {
        this.setUnsignedInt16(20, (int)(newStartCluster >> 16 & 0xFFFFL));
        this.setUnsignedInt16(26, (int)(newStartCluster & 0xFFFFL));
    }

    long getFileSize() {
        return this.getUnsignedInt32(28);
    }

    void setFileSize(long newSize) {
        this.setUnsignedInt32(28, newSize);
    }

    static FatDirectoryEntry createLfnPart(String unicode, int offset, byte checksum, int index, boolean isLast) {
        int diff;
        FatDirectoryEntry result = new FatDirectoryEntry();
        if (isLast && (diff = unicode.length() - offset) < 13) {
            StringBuilder builder = new StringBuilder(13);
            builder.append(unicode, offset, unicode.length());
            builder.append('\u0000');
            for (int i = 0; i < 13 - diff; ++i) {
                builder.append('\uffff');
            }
            offset = 0;
            unicode = builder.toString();
        }
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, (byte)(isLast ? index + 64 : index));
        buffer.putShort(1, (short)unicode.charAt(offset));
        buffer.putShort(3, (short)unicode.charAt(offset + 1));
        buffer.putShort(5, (short)unicode.charAt(offset + 2));
        buffer.putShort(7, (short)unicode.charAt(offset + 3));
        buffer.putShort(9, (short)unicode.charAt(offset + 4));
        buffer.put(11, (byte)15);
        buffer.put(12, (byte)0);
        buffer.put(13, checksum);
        buffer.putShort(14, (short)unicode.charAt(offset + 5));
        buffer.putShort(16, (short)unicode.charAt(offset + 6));
        buffer.putShort(18, (short)unicode.charAt(offset + 7));
        buffer.putShort(20, (short)unicode.charAt(offset + 8));
        buffer.putShort(22, (short)unicode.charAt(offset + 9));
        buffer.putShort(24, (short)unicode.charAt(offset + 10));
        buffer.putShort(26, (short)0);
        buffer.putShort(28, (short)unicode.charAt(offset + 11));
        buffer.putShort(30, (short)unicode.charAt(offset + 12));
        result.data = buffer;
        return result;
    }

    void extractLfnPart(StringBuilder builder) {
        int len;
        char[] name = new char[]{(char)this.data.getShort(1), (char)this.data.getShort(3), (char)this.data.getShort(5), (char)this.data.getShort(7), (char)this.data.getShort(9), (char)this.data.getShort(14), (char)this.data.getShort(16), (char)this.data.getShort(18), (char)this.data.getShort(20), (char)this.data.getShort(22), (char)this.data.getShort(24), (char)this.data.getShort(28), (char)this.data.getShort(30)};
        for (len = 0; len < 13 && name[len] != '\u0000'; ++len) {
        }
        builder.append(name, 0, len);
    }

    private int getUnsignedInt8(int offset) {
        return this.data.get(offset) & 0xFF;
    }

    private int getUnsignedInt16(int offset) {
        int i1 = this.data.get(offset) & 0xFF;
        int i2 = this.data.get(offset + 1) & 0xFF;
        return i2 << 8 | i1;
    }

    private long getUnsignedInt32(int offset) {
        long i1 = this.data.get(offset) & 0xFF;
        long i2 = this.data.get(offset + 1) & 0xFF;
        long i3 = this.data.get(offset + 2) & 0xFF;
        long i4 = this.data.get(offset + 3) & 0xFF;
        return i4 << 24 | i3 << 16 | i2 << 8 | i1;
    }

    private void setUnsignedInt16(int offset, int value) {
        this.data.put(offset, (byte)(value & 0xFF));
        this.data.put(offset + 1, (byte)(value >>> 8 & 0xFF));
    }

    private void setUnsignedInt32(int offset, long value) {
        this.data.put(offset, (byte)(value & 0xFFL));
        this.data.put(offset + 1, (byte)(value >>> 8 & 0xFFL));
        this.data.put(offset + 2, (byte)(value >>> 16 & 0xFFL));
        this.data.put(offset + 3, (byte)(value >>> 24 & 0xFFL));
    }

    private static long decodeDateTime(int date, int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1980 + (date >> 9));
        calendar.set(2, (date >> 5 & 0xF) - 1);
        calendar.set(5, date & 0x1F);
        calendar.set(11, time >> 11);
        calendar.set(12, time >> 5 & 0x3F);
        calendar.set(13, (time & 0x1F) * 2);
        return calendar.getTimeInMillis();
    }

    private static int encodeDate(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return (calendar.get(1) - 1980 << 9) + (calendar.get(2) + 1 << 5) + calendar.get(5);
    }

    private static int encodeTime(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return (calendar.get(11) << 11) + (calendar.get(12) << 5) + calendar.get(13) / 2;
    }

    public String toString() {
        return "[FatDirectoryEntry shortName=" + this.shortName.getString() + "]";
    }
}

