/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class Fat32BootSector {
    private static final int BYTES_PER_SECTOR_OFF = 11;
    private static final int SECTORS_PER_CLUSTER_OFF = 13;
    private static final int RESERVED_COUNT_OFF = 14;
    private static final int FAT_COUNT_OFF = 16;
    private static final int TOTAL_SECTORS_OFF = 32;
    private static final int SECTORS_PER_FAT_OFF = 36;
    private static final int FLAGS_OFF = 40;
    private static final int ROOT_DIR_CLUSTER_OFF = 44;
    private static final int FS_INFO_SECTOR_OFF = 48;
    private static final int VOLUME_LABEL_OFF = 48;
    private short bytesPerSector;
    private short sectorsPerCluster;
    private short reservedSectors;
    private byte fatCount;
    private long totalNumberOfSectors;
    private long sectorsPerFat;
    private long rootDirStartCluster;
    private short fsInfoStartSector;
    private boolean fatMirrored;
    private byte validFat;
    private String volumeLabel;

    private Fat32BootSector() {
    }

    static Fat32BootSector read(ByteBuffer buffer) {
        byte b;
        Fat32BootSector result = new Fat32BootSector();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        result.bytesPerSector = buffer.getShort(11);
        result.sectorsPerCluster = (short)(buffer.get(13) & 0xFF);
        result.reservedSectors = buffer.getShort(14);
        result.fatCount = buffer.get(16);
        result.totalNumberOfSectors = (long)buffer.getInt(32) & 0xFFFFFFFFL;
        result.sectorsPerFat = (long)buffer.getInt(36) & 0xFFFFFFFFL;
        result.rootDirStartCluster = (long)buffer.getInt(44) & 0xFFFFFFFFL;
        result.fsInfoStartSector = buffer.getShort(48);
        short flag = buffer.getShort(40);
        result.fatMirrored = ((byte)flag & 0x80) == 0;
        result.validFat = (byte)((byte)flag & 7);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 11 && (b = buffer.get(48 + i)) != 0; ++i) {
            builder.append((char)b);
        }
        result.volumeLabel = builder.toString();
        return result;
    }

    short getBytesPerSector() {
        return this.bytesPerSector;
    }

    short getSectorsPerCluster() {
        return this.sectorsPerCluster;
    }

    short getReservedSectors() {
        return this.reservedSectors;
    }

    byte getFatCount() {
        return this.fatCount;
    }

    long getTotalNumberOfSectors() {
        return this.totalNumberOfSectors;
    }

    long getSectorsPerFat() {
        return this.sectorsPerFat;
    }

    long getRootDirStartCluster() {
        return this.rootDirStartCluster;
    }

    short getFsInfoStartSector() {
        return this.fsInfoStartSector;
    }

    boolean isFatMirrored() {
        return this.fatMirrored;
    }

    byte getValidFat() {
        return this.validFat;
    }

    int getBytesPerCluster() {
        return this.sectorsPerCluster * this.bytesPerSector;
    }

    long getFatOffset(int fatNumber) {
        return (long)this.getBytesPerSector() * ((long)this.getReservedSectors() + (long)fatNumber * this.getSectorsPerFat());
    }

    long getDataAreaOffset() {
        return this.getFatOffset(0) + (long)this.getFatCount() * this.getSectorsPerFat() * (long)this.getBytesPerSector();
    }

    String getVolumeLabel() {
        return this.volumeLabel;
    }
}

