/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class UsbFileInputStream
extends InputStream {
    private static final String TAG = UsbFileInputStream.class.getSimpleName();
    private UsbFile file;
    private int currentByteOffset = 0;

    public UsbFileInputStream(UsbFile file) {
        if (file.isDirectory()) {
            throw new RuntimeException("UsbFileInputStream cannot be created on directory!");
        }
        this.file = file;
    }

    @Override
    public int available() throws IOException {
        Log.d((String)TAG, (String)"available");
        return 0;
    }

    @Override
    public int read() throws IOException {
        if ((long)this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.allocate(512);
        buffer.limit(1);
        this.file.read(this.currentByteOffset, buffer);
        ++this.currentByteOffset;
        buffer.flip();
        return buffer.get();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if ((long)this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long length = this.file.getLength();
        long toRead = Math.min((long)buffer.length, length - (long)this.currentByteOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.limit((int)toRead);
        this.file.read(this.currentByteOffset, byteBuffer);
        this.currentByteOffset = (int)((long)this.currentByteOffset + toRead);
        return (int)toRead;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if ((long)this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long length = this.file.getLength();
        long toRead = Math.min((long)byteCount, length - (long)this.currentByteOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.position(byteOffset);
        byteBuffer.limit((int)toRead + byteOffset);
        this.file.read(this.currentByteOffset, byteBuffer);
        this.currentByteOffset = (int)((long)this.currentByteOffset + toRead);
        return (int)toRead;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long skippedBytes = Math.min(byteCount, this.file.getLength() - (long)this.currentByteOffset);
        this.currentByteOffset = (int)((long)this.currentByteOffset + skippedBytes);
        return skippedBytes;
    }
}

