/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizool.technology.tableaccess.business;

import com.github.mizool.technology.tableaccess.business.Cell;
import com.github.mizool.technology.tableaccess.business.Column;
import java.util.stream.Stream;
import lombok.NonNull;

public final class TableData
implements AutoCloseable {
    @NonNull
    private final Iterable<Column> columns;
    @NonNull
    private final Stream<Iterable<Cell>> rows;

    @Override
    public void close() {
        this.rows.close();
    }

    TableData(@NonNull Iterable<Column> columns, @NonNull Stream<Iterable<Cell>> rows) {
        if (columns == null) {
            throw new NullPointerException("columns");
        }
        if (rows == null) {
            throw new NullPointerException("rows");
        }
        this.columns = columns;
        this.rows = rows;
    }

    public static TableDataBuilder builder() {
        return new TableDataBuilder();
    }

    public TableDataBuilder toBuilder() {
        return new TableDataBuilder().columns(this.columns).rows(this.rows);
    }

    @NonNull
    public Iterable<Column> getColumns() {
        return this.columns;
    }

    @NonNull
    public Stream<Iterable<Cell>> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableData)) {
            return false;
        }
        TableData other = (TableData)o;
        Iterable<Column> this$columns = this.getColumns();
        Iterable<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        Stream<Iterable<Cell>> this$rows = this.getRows();
        Stream<Iterable<Cell>> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !this$rows.equals(other$rows));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Iterable<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        Stream<Iterable<Cell>> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : $rows.hashCode());
        return result;
    }

    public String toString() {
        return "TableData(columns=" + this.getColumns() + ", rows=" + this.getRows() + ")";
    }

    public static class TableDataBuilder {
        private Iterable<Column> columns;
        private Stream<Iterable<Cell>> rows;

        TableDataBuilder() {
        }

        public TableDataBuilder columns(Iterable<Column> columns) {
            this.columns = columns;
            return this;
        }

        public TableDataBuilder rows(Stream<Iterable<Cell>> rows) {
            this.rows = rows;
            return this;
        }

        public TableData build() {
            return new TableData(this.columns, this.rows);
        }

        public String toString() {
            return "TableData.TableDataBuilder(columns=" + this.columns + ", rows=" + this.rows + ")";
        }
    }
}

