/*
 * Decompiled with CFR 0.152.
 */
package ir.mirrajabi.okhttpjsonmock.interceptors;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import ir.mirrajabi.okhttpjsonmock.helpers.ResourcesHelper;
import ir.mirrajabi.okhttpjsonmock.models.MockedResponse;
import java.io.IOException;
import java.util.Random;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpMockInterceptor
implements Interceptor {
    private Context mContext;
    private int mFailurePercentage;
    private String mBasePath;

    public OkHttpMockInterceptor(Context context, int failurePercentage) {
        this(context, failurePercentage, "");
    }

    public OkHttpMockInterceptor(Context context, int failurePercentage, String basePath) {
        this.mContext = context;
        this.mFailurePercentage = failurePercentage;
        this.mBasePath = basePath;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        int statusCode;
        String query;
        Gson gson = new GsonBuilder().setLenient().create();
        HttpUrl url = chain.request().url();
        String sym = "";
        String string = query = url.encodedQuery() == null ? "" : url.encodedQuery();
        if (!query.equals("")) {
            sym = "/";
        }
        String path = url.encodedPath() + sym + query;
        String responseString = ResourcesHelper.loadAssetTextAsString(this.mContext, this.mBasePath + path.substring(1).toLowerCase() + ".json");
        if (responseString == null) {
            responseString = ResourcesHelper.loadAssetTextAsString(this.mContext, this.mBasePath + url.encodedPath().substring(1).toLowerCase() + ".json");
        }
        MockedResponse mockedResponse = new MockedResponse().setResponse(new LinkedTreeMap()).setStatusCode(404);
        if (responseString != null) {
            try {
                mockedResponse = (MockedResponse)gson.fromJson(responseString, MockedResponse.class);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        JsonObject jsonObject = gson.toJsonTree((Object)mockedResponse.getResponse()).getAsJsonObject();
        String result = jsonObject.toString();
        JsonArray items = jsonObject.getAsJsonArray("items");
        if (items != null) {
            result = gson.toJson((JsonElement)items);
        }
        try {
            Thread.sleep(Math.abs(new Random().nextInt() % 1500) + 500);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean failure = Math.abs(new Random().nextInt() % 100) < this.mFailurePercentage;
        int n = statusCode = failure ? 504 : mockedResponse.getStatusCode();
        if (failure) {
            Log.e((String)"JsonMockServer", (String)("Returning result from " + path + "\t\tStatusCode : " + statusCode));
        } else {
            Log.v((String)"JsonMockServer", (String)("Returning result from " + path + "\t\tStatusCode : " + statusCode));
        }
        return new Response.Builder().code(statusCode).message(responseString).request(chain.request()).protocol(Protocol.HTTP_1_0).body(ResponseBody.create((MediaType)MediaType.parse((String)"application/json"), (String)result)).addHeader("content-type", "application/json").build();
    }
}

