/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GsmModemSerialDriver
implements UsbSerialDriver {
    private final String TAG = GsmModemSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    public GsmModemSerialDriver(UsbDevice mDevice) {
        this.mDevice = mDevice;
        this.mPort = new GsmModemSerialPort(mDevice, 0);
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(6018, new int[]{19728, 19730});
        return supportedDevices;
    }

    public class GsmModemSerialPort
    extends CommonUsbSerialPort {
        private UsbInterface mDataInterface;

        public GsmModemSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
        }

        @Override
        protected void openInt() throws IOException {
            Log.d((String)GsmModemSerialDriver.this.TAG, (String)("claiming interfaces, count=" + this.mDevice.getInterfaceCount()));
            this.mDataInterface = this.mDevice.getInterface(0);
            if (!this.mConnection.claimInterface(this.mDataInterface, true)) {
                throw new IOException("Could not claim shared control/data interface");
            }
            Log.d((String)GsmModemSerialDriver.this.TAG, (String)("endpoint count=" + this.mDataInterface.getEndpointCount()));
            for (int i = 0; i < this.mDataInterface.getEndpointCount(); ++i) {
                UsbEndpoint ep = this.mDataInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 2) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                if (ep.getDirection() != 0 || ep.getType() != 2) continue;
                this.mWriteEndpoint = ep;
            }
            this.initGsmModem();
        }

        @Override
        protected void closeInt() {
            try {
                this.mConnection.releaseInterface(this.mDataInterface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int initGsmModem() throws IOException {
            int len = this.mConnection.controlTransfer(33, 34, 1, 0, null, 0, 5000);
            if (len < 0) {
                throw new IOException("init failed");
            }
            return len;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return GsmModemSerialDriver.this;
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

