/*
 * Decompiled with CFR 0.152.
 */
package com.inqbarna.tablefixheaders;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Scroller;
import com.inqbarna.tablefixheaders.R;
import com.inqbarna.tablefixheaders.Recycler;
import com.inqbarna.tablefixheaders.adapters.TableAdapter;
import java.util.ArrayList;
import java.util.List;

public class TableFixHeaders
extends ViewGroup {
    private int currentX;
    private int currentY;
    private TableAdapter adapter;
    private int scrollX;
    private int scrollY;
    private int firstRow;
    private int firstColumn;
    private int[] widths;
    private int[] heights;
    private View headView = null;
    private List<View> rowViewList = new ArrayList<View>();
    private List<View> columnViewList = new ArrayList<View>();
    private List<List<View>> bodyViewTable = new ArrayList<List<View>>();
    private int rowCount;
    private int columnCount;
    private int width;
    private int height;
    private Recycler recycler;
    private TableAdapterDataSetObserver tableAdapterDataSetObserver;
    private boolean needRelayout = true;
    private final ImageView[] shadows = new ImageView[4];
    private final int shadowSize;
    private final int minimumVelocity;
    private final int maximumVelocity;
    private final Flinger flinger;
    private VelocityTracker velocityTracker;
    private int touchSlop;

    public TableFixHeaders(Context context) {
        this(context, null);
    }

    public TableFixHeaders(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.shadows[0] = new ImageView(context);
        this.shadows[0].setImageResource(R.drawable.shadow_left);
        this.shadows[1] = new ImageView(context);
        this.shadows[1].setImageResource(R.drawable.shadow_top);
        this.shadows[2] = new ImageView(context);
        this.shadows[2].setImageResource(R.drawable.shadow_right);
        this.shadows[3] = new ImageView(context);
        this.shadows[3].setImageResource(R.drawable.shadow_bottom);
        this.shadowSize = this.getResources().getDimensionPixelSize(R.dimen.shadow_size);
        this.flinger = new Flinger(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.minimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.setWillNotDraw(false);
    }

    public TableAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(TableAdapter adapter) {
        if (this.adapter != null) {
            this.adapter.unregisterDataSetObserver(this.tableAdapterDataSetObserver);
        }
        this.adapter = adapter;
        this.tableAdapterDataSetObserver = new TableAdapterDataSetObserver();
        this.adapter.registerDataSetObserver(this.tableAdapterDataSetObserver);
        this.recycler = new Recycler(adapter.getViewTypeCount());
        this.scrollX = 0;
        this.scrollY = 0;
        this.firstColumn = 0;
        this.firstRow = 0;
        this.needRelayout = true;
        this.requestLayout();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        boolean intercept = false;
        switch (event.getAction()) {
            case 0: {
                this.currentX = (int)event.getRawX();
                this.currentY = (int)event.getRawY();
                break;
            }
            case 2: {
                int x2 = Math.abs(this.currentX - (int)event.getRawX());
                int y2 = Math.abs(this.currentY - (int)event.getRawY());
                if (x2 <= this.touchSlop && y2 <= this.touchSlop) break;
                intercept = true;
                break;
            }
        }
        return intercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                if (!this.flinger.isFinished()) {
                    this.flinger.forceFinished();
                }
                this.currentX = (int)event.getRawX();
                this.currentY = (int)event.getRawY();
                break;
            }
            case 2: {
                int x2 = (int)event.getRawX();
                int y2 = (int)event.getRawY();
                int diffX = this.currentX - x2;
                int diffY = this.currentY - y2;
                this.currentX = x2;
                this.currentY = y2;
                this.scrollBy(diffX, diffY);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.velocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
                int velocityX = (int)velocityTracker.getXVelocity();
                int velocityY = (int)velocityTracker.getYVelocity();
                if (Math.abs(velocityX) > this.minimumVelocity || Math.abs(velocityY) > this.minimumVelocity) {
                    this.flinger.start(this.getActualScrollX(), this.getActualScrollY(), velocityX, velocityY, this.getMaxScrollX(), this.getMaxScrollY());
                    break;
                }
                if (this.velocityTracker == null) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
                break;
            }
        }
        return true;
    }

    public void scrollTo(int x, int y) {
        if (this.needRelayout) {
            this.scrollX = x;
            this.firstColumn = 0;
            this.scrollY = y;
            this.firstRow = 0;
        } else {
            this.scrollBy(x - this.sumArray(this.widths, 1, this.firstColumn) - this.scrollX, y - this.sumArray(this.heights, 1, this.firstRow) - this.scrollY);
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollX += x;
        this.scrollY += y;
        if (this.needRelayout) {
            return;
        }
        this.scrollBounds();
        if (this.scrollX != 0) {
            if (this.scrollX > 0) {
                while (this.widths[this.firstColumn + 1] < this.scrollX) {
                    if (!this.rowViewList.isEmpty()) {
                        this.removeLeft();
                    }
                    this.scrollX -= this.widths[this.firstColumn + 1];
                    ++this.firstColumn;
                }
                while (this.getFilledWidth() < this.width) {
                    this.addRight();
                }
            } else {
                while (!this.rowViewList.isEmpty() && this.getFilledWidth() - this.widths[this.firstColumn + this.rowViewList.size()] >= this.width) {
                    this.removeRight();
                }
                if (this.rowViewList.isEmpty()) {
                    while (this.scrollX < 0) {
                        --this.firstColumn;
                        this.scrollX += this.widths[this.firstColumn + 1];
                    }
                    while (this.getFilledWidth() < this.width) {
                        this.addRight();
                    }
                } else {
                    while (0 > this.scrollX) {
                        this.addLeft();
                        --this.firstColumn;
                        this.scrollX += this.widths[this.firstColumn + 1];
                    }
                }
            }
        }
        if (this.scrollY != 0) {
            if (this.scrollY > 0) {
                while (this.heights[this.firstRow + 1] < this.scrollY) {
                    if (!this.columnViewList.isEmpty()) {
                        this.removeTop();
                    }
                    this.scrollY -= this.heights[this.firstRow + 1];
                    ++this.firstRow;
                }
                while (this.getFilledHeight() < this.height) {
                    this.addBottom();
                }
            } else {
                while (!this.columnViewList.isEmpty() && this.getFilledHeight() - this.heights[this.firstRow + this.columnViewList.size()] >= this.height) {
                    this.removeBottom();
                }
                if (this.columnViewList.isEmpty()) {
                    while (this.scrollY < 0) {
                        --this.firstRow;
                        this.scrollY += this.heights[this.firstRow + 1];
                    }
                    while (this.getFilledHeight() < this.height) {
                        this.addBottom();
                    }
                } else {
                    while (0 > this.scrollY) {
                        this.addTop();
                        --this.firstRow;
                        this.scrollY += this.heights[this.firstRow + 1];
                    }
                }
            }
        }
        this.repositionViews();
        this.shadowsVisibility();
        this.awakenScrollBars();
    }

    protected int computeHorizontalScrollExtent() {
        float tableSize = this.width - this.widths[0];
        float contentSize = this.sumArray(this.widths) - this.widths[0];
        float percentageOfVisibleView = tableSize / contentSize;
        return Math.round(percentageOfVisibleView * tableSize);
    }

    protected int computeHorizontalScrollOffset() {
        float maxScrollX = this.sumArray(this.widths) - this.width;
        float percentageOfViewScrolled = (float)this.getActualScrollX() / maxScrollX;
        int maxHorizontalScrollOffset = this.width - this.widths[0] - this.computeHorizontalScrollExtent();
        return this.widths[0] + Math.round(percentageOfViewScrolled * (float)maxHorizontalScrollOffset);
    }

    protected int computeHorizontalScrollRange() {
        return this.width;
    }

    protected int computeVerticalScrollExtent() {
        float tableSize = this.height - this.heights[0];
        float contentSize = this.sumArray(this.heights) - this.heights[0];
        float percentageOfVisibleView = tableSize / contentSize;
        return Math.round(percentageOfVisibleView * tableSize);
    }

    protected int computeVerticalScrollOffset() {
        float maxScrollY = this.sumArray(this.heights) - this.height;
        float percentageOfViewScrolled = (float)this.getActualScrollY() / maxScrollY;
        int maxHorizontalScrollOffset = this.height - this.heights[0] - this.computeVerticalScrollExtent();
        return this.heights[0] + Math.round(percentageOfViewScrolled * (float)maxHorizontalScrollOffset);
    }

    protected int computeVerticalScrollRange() {
        return this.height;
    }

    public int getActualScrollX() {
        return this.scrollX + this.sumArray(this.widths, 1, this.firstColumn);
    }

    public int getActualScrollY() {
        return this.scrollY + this.sumArray(this.heights, 1, this.firstRow);
    }

    private int getMaxScrollX() {
        return Math.max(0, this.sumArray(this.widths) - this.width);
    }

    private int getMaxScrollY() {
        return Math.max(0, this.sumArray(this.heights) - this.height);
    }

    private int getFilledWidth() {
        return this.widths[0] + this.sumArray(this.widths, this.firstColumn + 1, this.rowViewList.size()) - this.scrollX;
    }

    private int getFilledHeight() {
        return this.heights[0] + this.sumArray(this.heights, this.firstRow + 1, this.columnViewList.size()) - this.scrollY;
    }

    private void addLeft() {
        this.addLeftOrRight(this.firstColumn - 1, 0);
    }

    private void addTop() {
        this.addTopAndBottom(this.firstRow - 1, 0);
    }

    private void addRight() {
        int size = this.rowViewList.size();
        this.addLeftOrRight(this.firstColumn + size, size);
    }

    private void addBottom() {
        int size = this.columnViewList.size();
        this.addTopAndBottom(this.firstRow + size, size);
    }

    private void addLeftOrRight(int column, int index) {
        View view = this.makeView(-1, column, this.widths[column + 1], this.heights[0]);
        this.rowViewList.add(index, view);
        int i = this.firstRow;
        for (List<View> list : this.bodyViewTable) {
            view = this.makeView(i, column, this.widths[column + 1], this.heights[i + 1]);
            list.add(index, view);
            ++i;
        }
    }

    private void addTopAndBottom(int row, int index) {
        View view = this.makeView(row, -1, this.widths[0], this.heights[row + 1]);
        this.columnViewList.add(index, view);
        ArrayList<View> list = new ArrayList<View>();
        int size = this.rowViewList.size() + this.firstColumn;
        for (int i = this.firstColumn; i < size; ++i) {
            view = this.makeView(row, i, this.widths[i + 1], this.heights[row + 1]);
            list.add(view);
        }
        this.bodyViewTable.add(index, list);
    }

    private void removeLeft() {
        this.removeLeftOrRight(0);
    }

    private void removeTop() {
        this.removeTopOrBottom(0);
    }

    private void removeRight() {
        this.removeLeftOrRight(this.rowViewList.size() - 1);
    }

    private void removeBottom() {
        this.removeTopOrBottom(this.columnViewList.size() - 1);
    }

    private void removeLeftOrRight(int position) {
        this.removeView(this.rowViewList.remove(position));
        for (List<View> list : this.bodyViewTable) {
            this.removeView(list.remove(position));
        }
    }

    private void removeTopOrBottom(int position) {
        this.removeView(this.columnViewList.remove(position));
        List<View> remove = this.bodyViewTable.remove(position);
        for (View view : remove) {
            this.removeView(view);
        }
    }

    public void removeView(View view) {
        super.removeView(view);
        int typeView = (Integer)view.getTag(R.id.tag_type_view);
        if (typeView != -1) {
            this.recycler.addRecycledView(view, typeView);
        }
    }

    private void repositionViews() {
        int bottom;
        int right;
        int left = this.widths[0] - this.scrollX;
        int i = this.firstColumn;
        for (View view : this.rowViewList) {
            right = left + this.widths[++i];
            view.layout(left, 0, right, this.heights[0]);
            left = right;
        }
        int top = this.heights[0] - this.scrollY;
        i = this.firstRow;
        for (View view : this.columnViewList) {
            bottom = top + this.heights[++i];
            view.layout(0, top, this.widths[0], bottom);
            top = bottom;
        }
        top = this.heights[0] - this.scrollY;
        i = this.firstRow;
        for (List list : this.bodyViewTable) {
            bottom = top + this.heights[++i];
            left = this.widths[0] - this.scrollX;
            int j = this.firstColumn;
            for (View view : list) {
                right = left + this.widths[++j];
                view.layout(left, top, right, bottom);
                left = right;
            }
            top = bottom;
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int h;
        int w;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.adapter != null) {
            int i;
            this.rowCount = this.adapter.getRowCount();
            this.columnCount = this.adapter.getColumnCount();
            this.widths = new int[this.columnCount + 1];
            for (i = -1; i < this.columnCount; ++i) {
                int n = i + 1;
                this.widths[n] = this.widths[n] + this.adapter.getWidth(i);
            }
            this.heights = new int[this.rowCount + 1];
            for (i = -1; i < this.rowCount; ++i) {
                int n = i + 1;
                this.heights[n] = this.heights[n] + this.adapter.getHeight(i);
            }
            if (widthMode == Integer.MIN_VALUE) {
                w = Math.min(widthSize, this.sumArray(this.widths));
            } else if (widthMode == 0) {
                w = this.sumArray(this.widths);
            } else {
                w = widthSize;
                int sumArray = this.sumArray(this.widths);
                if (sumArray < widthSize) {
                    float factor = (float)widthSize / (float)sumArray;
                    for (int i2 = 1; i2 < this.widths.length; ++i2) {
                        this.widths[i2] = Math.round((float)this.widths[i2] * factor);
                    }
                    this.widths[0] = widthSize - this.sumArray(this.widths, 1, this.widths.length - 1);
                }
            }
            h = heightMode == Integer.MIN_VALUE ? Math.min(heightSize, this.sumArray(this.heights)) : (heightMode == 0 ? this.sumArray(this.heights) : heightSize);
        } else if (heightMode == Integer.MIN_VALUE || widthMode == 0) {
            w = 0;
            h = 0;
        } else {
            w = widthSize;
            h = heightSize;
        }
        if (this.firstRow >= this.rowCount || this.getMaxScrollY() - this.getActualScrollY() < 0) {
            this.firstRow = 0;
            this.scrollY = Integer.MAX_VALUE;
        }
        if (this.firstColumn >= this.columnCount || this.getMaxScrollX() - this.getActualScrollX() < 0) {
            this.firstColumn = 0;
            this.scrollX = Integer.MAX_VALUE;
        }
        this.setMeasuredDimension(w, h);
    }

    private int sumArray(int[] array) {
        return this.sumArray(array, 0, array.length);
    }

    private int sumArray(int[] array, int firstIndex, int count) {
        int sum = 0;
        count += firstIndex;
        for (int i = firstIndex; i < count; ++i) {
            sum += array[i];
        }
        return sum;
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.needRelayout || changed) {
            this.needRelayout = false;
            this.resetTable();
            if (this.adapter != null) {
                View view;
                int i;
                this.width = r - l;
                this.height = b - t;
                int right = Math.min(this.width, this.sumArray(this.widths));
                int bottom = Math.min(this.height, this.sumArray(this.heights));
                this.addShadow(this.shadows[0], this.widths[0], 0, this.widths[0] + this.shadowSize, bottom);
                this.addShadow(this.shadows[1], 0, this.heights[0], right, this.heights[0] + this.shadowSize);
                this.addShadow(this.shadows[2], right - this.shadowSize, 0, right, bottom);
                this.addShadow(this.shadows[3], 0, bottom - this.shadowSize, right, bottom);
                this.headView = this.makeAndSetup(-1, -1, 0, 0, this.widths[0], this.heights[0]);
                this.scrollBounds();
                this.adjustFirstCellsAndScroll();
                int left = this.widths[0] - this.scrollX;
                for (i = this.firstColumn; i < this.columnCount && left < this.width; ++i) {
                    right = left + this.widths[i + 1];
                    view = this.makeAndSetup(-1, i, left, 0, right, this.heights[0]);
                    this.rowViewList.add(view);
                    left = right;
                }
                int top = this.heights[0] - this.scrollY;
                for (i = this.firstRow; i < this.rowCount && top < this.height; ++i) {
                    bottom = top + this.heights[i + 1];
                    view = this.makeAndSetup(i, -1, 0, top, this.widths[0], bottom);
                    this.columnViewList.add(view);
                    top = bottom;
                }
                top = this.heights[0] - this.scrollY;
                for (i = this.firstRow; i < this.rowCount && top < this.height; ++i) {
                    bottom = top + this.heights[i + 1];
                    left = this.widths[0] - this.scrollX;
                    ArrayList<View> list = new ArrayList<View>();
                    for (int j = this.firstColumn; j < this.columnCount && left < this.width; ++j) {
                        right = left + this.widths[j + 1];
                        View view2 = this.makeAndSetup(i, j, left, top, right, bottom);
                        list.add(view2);
                        left = right;
                    }
                    this.bodyViewTable.add(list);
                    top = bottom;
                }
                this.shadowsVisibility();
            }
        }
    }

    private void scrollBounds() {
        this.scrollX = this.scrollBounds(this.scrollX, this.firstColumn, this.widths, this.width);
        this.scrollY = this.scrollBounds(this.scrollY, this.firstRow, this.heights, this.height);
    }

    private int scrollBounds(int desiredScroll, int firstCell, int[] sizes, int viewSize) {
        if (desiredScroll != 0) {
            desiredScroll = desiredScroll < 0 ? Math.max(desiredScroll, -this.sumArray(sizes, 1, firstCell)) : Math.min(desiredScroll, Math.max(0, this.sumArray(sizes, firstCell + 1, sizes.length - 1 - firstCell) + sizes[0] - viewSize));
        }
        return desiredScroll;
    }

    private void adjustFirstCellsAndScroll() {
        int[] values = this.adjustFirstCellsAndScroll(this.scrollX, this.firstColumn, this.widths);
        this.scrollX = values[0];
        this.firstColumn = values[1];
        values = this.adjustFirstCellsAndScroll(this.scrollY, this.firstRow, this.heights);
        this.scrollY = values[0];
        this.firstRow = values[1];
    }

    private int[] adjustFirstCellsAndScroll(int scroll, int firstCell, int[] sizes) {
        block4: {
            if (scroll == 0) break block4;
            if (scroll > 0) {
                while (sizes[firstCell + 1] < scroll) {
                    scroll -= sizes[++firstCell];
                }
            } else {
                while (scroll < 0) {
                    scroll += sizes[firstCell];
                    --firstCell;
                }
            }
        }
        return new int[]{scroll, firstCell};
    }

    private void shadowsVisibility() {
        int actualScrollX = this.getActualScrollX();
        int actualScrollY = this.getActualScrollY();
        int[] remainPixels = new int[]{actualScrollX, actualScrollY, this.getMaxScrollX() - actualScrollX, this.getMaxScrollY() - actualScrollY};
        for (int i = 0; i < this.shadows.length; ++i) {
            this.setAlpha(this.shadows[i], Math.min((float)remainPixels[i] / (float)this.shadowSize, 1.0f));
        }
    }

    @TargetApi(value=11)
    private void setAlpha(ImageView imageView, float alpha) {
        if (Build.VERSION.SDK_INT >= 11) {
            imageView.setAlpha(alpha);
        } else {
            imageView.setAlpha(Math.round(alpha * 255.0f));
        }
    }

    private void addShadow(ImageView imageView, int l, int t, int r, int b) {
        imageView.layout(l, t, r, b);
        this.addView((View)imageView);
    }

    private void resetTable() {
        this.headView = null;
        this.rowViewList.clear();
        this.columnViewList.clear();
        this.bodyViewTable.clear();
        this.removeAllViews();
    }

    private View makeAndSetup(int row, int column, int left, int top, int right, int bottom) {
        View view = this.makeView(row, column, right - left, bottom - top);
        view.layout(left, top, right, bottom);
        return view;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean ret;
        Integer row = (Integer)child.getTag(R.id.tag_row);
        Integer column = (Integer)child.getTag(R.id.tag_column);
        if (row == null || row == -1 && column == -1) {
            ret = super.drawChild(canvas, child, drawingTime);
        } else {
            canvas.save();
            if (row == -1) {
                canvas.clipRect(this.widths[0], 0, canvas.getWidth(), canvas.getHeight());
            } else if (column == -1) {
                canvas.clipRect(0, this.heights[0], canvas.getWidth(), canvas.getHeight());
            } else {
                canvas.clipRect(this.widths[0], this.heights[0], canvas.getWidth(), canvas.getHeight());
            }
            ret = super.drawChild(canvas, child, drawingTime);
            canvas.restore();
        }
        return ret;
    }

    private View makeView(int row, int column, int w, int h) {
        int itemViewType = this.adapter.getItemViewType(row, column);
        View recycledView = itemViewType == -1 ? null : this.recycler.getRecycledView(itemViewType);
        View view = this.adapter.getView(row, column, recycledView, this);
        view.setTag(R.id.tag_type_view, (Object)itemViewType);
        view.setTag(R.id.tag_row, (Object)row);
        view.setTag(R.id.tag_column, (Object)column);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000));
        this.addTableView(view, row, column);
        return view;
    }

    private void addTableView(View view, int row, int column) {
        if (row == -1 && column == -1) {
            this.addView(view, this.getChildCount() - 4);
        } else if (row == -1 || column == -1) {
            this.addView(view, this.getChildCount() - 5);
        } else {
            this.addView(view, 0);
        }
    }

    private class Flinger
    implements Runnable {
        private final Scroller scroller;
        private int lastX = 0;
        private int lastY = 0;

        Flinger(Context context) {
            this.scroller = new Scroller(context);
        }

        void start(int initX, int initY, int initialVelocityX, int initialVelocityY, int maxX, int maxY) {
            this.scroller.fling(initX, initY, initialVelocityX, initialVelocityY, 0, maxX, 0, maxY);
            this.lastX = initX;
            this.lastY = initY;
            TableFixHeaders.this.post(this);
        }

        @Override
        public void run() {
            if (this.scroller.isFinished()) {
                return;
            }
            boolean more = this.scroller.computeScrollOffset();
            int x = this.scroller.getCurrX();
            int y = this.scroller.getCurrY();
            int diffX = this.lastX - x;
            int diffY = this.lastY - y;
            if (diffX != 0 || diffY != 0) {
                TableFixHeaders.this.scrollBy(diffX, diffY);
                this.lastX = x;
                this.lastY = y;
            }
            if (more) {
                TableFixHeaders.this.post(this);
            }
        }

        boolean isFinished() {
            return this.scroller.isFinished();
        }

        void forceFinished() {
            if (!this.scroller.isFinished()) {
                this.scroller.forceFinished(true);
            }
        }
    }

    private class TableAdapterDataSetObserver
    extends DataSetObserver {
        private TableAdapterDataSetObserver() {
        }

        public void onChanged() {
            TableFixHeaders.this.needRelayout = true;
            TableFixHeaders.this.requestLayout();
        }

        public void onInvalidated() {
        }
    }
}

