/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2;

import android.app.Activity;
import android.app.Application;
import android.support.v4.app.Fragment;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.Size;
import com.miguelbcr.ui.rx_paparazzo2.internal.di.ApplicationComponent;
import com.miguelbcr.ui.rx_paparazzo2.internal.di.ApplicationModule;
import com.yalantis.ucrop.UCrop;
import io.reactivex.Observable;
import java.util.List;
import rx_activity_result2.RxActivityResult;

public final class RxPaparazzo {
    public static final int RESULT_DENIED_PERMISSION = 2;
    public static final int RESULT_DENIED_PERMISSION_NEVER_ASK = 3;
    private static String fileProviderAuthority;
    private static String fileProviderPath;

    private RxPaparazzo() {
    }

    public static RegisterBuilder register(Application application) {
        RxActivityResult.register((Application)application);
        return new RegisterBuilder();
    }

    public static <T extends Activity> SingleSelectionBuilder<T> single(T activity) {
        return new SingleSelectionBuilder<T>(activity);
    }

    public static <T extends Fragment> SingleSelectionBuilder<T> single(T fragment) {
        return new SingleSelectionBuilder<T>(fragment);
    }

    public static <T extends Activity> MultipleSelectionBuilder<T> multiple(T activity) {
        return new MultipleSelectionBuilder<T>(activity);
    }

    public static <T extends Fragment> MultipleSelectionBuilder<T> multiple(T fragment) {
        return new MultipleSelectionBuilder<T>(fragment);
    }

    public static class MultipleSelectionBuilder<T>
    extends Builder<T, MultipleSelectionBuilder<T>> {
        MultipleSelectionBuilder(T ui) {
            super(ui);
        }

        public Observable<Response<T, List<FileData>>> usingGallery() {
            this.getConfig().setPickMimeType("image/*");
            return this.usingFiles();
        }

        public Observable<Response<T, List<FileData>>> usingFiles() {
            return this.getApplicationComponent().files().pickFiles();
        }
    }

    public static class SingleSelectionBuilder<T>
    extends Builder<T, SingleSelectionBuilder<T>> {
        SingleSelectionBuilder(T ui) {
            super(ui);
        }

        public Observable<Response<T, FileData>> usingGallery() {
            Config config = this.getConfig();
            config.setPickMimeType("image/*");
            config.setFailCropIfNotImage(true);
            return this.usingFiles();
        }

        public Observable<Response<T, FileData>> usingCamera() {
            this.getConfig().setFailCropIfNotImage(true);
            return this.getApplicationComponent().camera().takePhoto();
        }

        public Observable<Response<T, FileData>> usingFiles() {
            return this.getApplicationComponent().files().pickFile();
        }
    }

    private static abstract class Builder<T, B extends Builder<T, B>> {
        private final ApplicationComponent applicationComponent;
        private final B self = this;
        private final Config config = new Config();

        Builder(T ui) {
            this.config.setFileProviderAuthority(fileProviderAuthority);
            this.config.setFileProviderPath(fileProviderPath);
            this.applicationComponent = ApplicationComponent.create(new ApplicationModule(this.config, ui));
        }

        ApplicationComponent getApplicationComponent() {
            return this.applicationComponent;
        }

        Config getConfig() {
            return this.config;
        }

        public B setMaximumFileSizeInBytes(long maximumFileSizeInBytes) {
            this.config.setMaximumFileSize(maximumFileSizeInBytes);
            return this.self;
        }

        public B limitPickerToOpenableFilesOnly() {
            this.config.setPickOpenableOnly(true);
            return this.self;
        }

        public B useInternalStorage() {
            this.config.setUseInternalStorage(true);
            return this.self;
        }

        public B size(Size size) {
            this.config.setSize(size);
            return this.self;
        }

        public B setMimeType(String mimeType) {
            this.config.setPickMimeType(mimeType);
            return this.self;
        }

        public B setMultipleMimeType(String ... mimeType) {
            this.config.setPickMultipleMimeTypes(mimeType);
            return this.self;
        }

        public B crop() {
            this.config.setCrop();
            return this.self;
        }

        public <O extends UCrop.Options> B crop(O options) {
            this.config.setCrop(options);
            return this.self;
        }

        public B sendToMediaScanner() {
            this.config.setSendToMediaScanner(true);
            return this.self;
        }

        public B useDocumentPicker() {
            this.config.setUseDocumentPicker(true);
            return this.self;
        }
    }

    public static class RegisterBuilder {
        private final RegisterBuilder self = this;

        RegisterBuilder() {
        }

        public RegisterBuilder withFileProviderAuthority(String authority) {
            fileProviderAuthority = authority;
            return this.self;
        }

        public RegisterBuilder withFileProviderPath(String path) {
            fileProviderPath = path;
            return this.self;
        }
    }
}

