/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.workers;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.Ignore;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.CropImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GrantPermissions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PermissionUtil;
import com.miguelbcr.ui.rx_paparazzo2.interactors.SaveFile;
import com.miguelbcr.ui.rx_paparazzo2.interactors.TakePhoto;
import com.miguelbcr.ui.rx_paparazzo2.workers.Worker;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.Arrays;

public final class Camera
extends Worker {
    private final TakePhoto takePhoto;
    private final CropImage cropImage;
    private final SaveFile saveFile;
    private final GrantPermissions grantPermissions;
    private final TargetUi targetUi;
    private final Config config;

    public Camera(TakePhoto takePhoto, CropImage cropImage, SaveFile saveFile, GrantPermissions grantPermissions, TargetUi targetUi, Config config) {
        super(targetUi);
        this.takePhoto = takePhoto;
        this.cropImage = cropImage;
        this.saveFile = saveFile;
        this.grantPermissions = grantPermissions;
        this.targetUi = targetUi;
        this.config = config;
    }

    public <T> Observable<Response<T, FileData>> takePhoto() {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Function)new Function<Ignore, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(Ignore ignore) throws Exception {
                return Camera.this.takePhoto.react();
            }
        }).flatMap((Function)new Function<FileData, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(FileData fileData) throws Exception {
                return Camera.this.handleSavingFile(fileData);
            }
        }).map(new Function<FileData, Response<T, FileData>>(){

            public Response<T, FileData> apply(FileData fileData) throws Exception {
                return new Response<Object, FileData>(Camera.this.targetUi.ui(), fileData, -1);
            }
        }).compose(this.applyOnError());
    }

    private Observable<FileData> handleSavingFile(FileData sourceFileData) {
        return this.cropImage.with(sourceFileData).react().flatMap((Function)new Function<FileData, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(FileData cropped) throws Exception {
                return Camera.this.saveFile.with(cropped).react();
            }
        });
    }

    private String[] permissions() {
        String[] storagePermission = PermissionUtil.getReadAndWriteStoragePermissions(this.config.isUseInternalStorage());
        String[] cameraPermission = this.getCameraPermission();
        return Camera.concat(storagePermission, cameraPermission);
    }

    private String[] getCameraPermission() {
        if (this.hasCameraPermissionInManifest()) {
            return new String[]{"android.permission.CAMERA"};
        }
        return new String[0];
    }

    private static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private boolean hasCameraPermissionInManifest() {
        try {
            String packageName = this.targetUi.getContext().getPackageName();
            PackageManager pm = this.targetUi.getContext().getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null && declaredPermissions.length > 0) {
                for (String p : declaredPermissions) {
                    if (!p.equals("android.permission.CAMERA")) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

