/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Intent;
import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.Options;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import com.yalantis.ucrop.UCrop;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.FileNotFoundException;

public final class CropImage
extends UseCase<FileData> {
    private static final String CROP_APPEND = "CROPPED-";
    private final Config config;
    private final StartIntent startIntent;
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;
    private FileData fileData;

    public CropImage(TargetUi targetUi, Config config, StartIntent startIntent, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.config = config;
        this.startIntent = startIntent;
        this.imageUtils = imageUtils;
    }

    public CropImage with(FileData fileData) {
        this.fileData = fileData;
        return this;
    }

    @Override
    public Observable<FileData> react() {
        if (this.config.isDoCrop()) {
            if (!this.isImage()) {
                if (this.config.isFailCropIfNotImage()) {
                    throw new IllegalArgumentException("Expected an image file, cannot perform image crop");
                }
                return Observable.just((Object)this.fileData);
            }
            return this.cropImage();
        }
        return Observable.just((Object)this.fileData);
    }

    private Observable<FileData> cropImage() {
        final File outputFile = this.getOutputFile();
        Uri outputUri = Uri.fromFile((File)outputFile);
        Observable intent = Observable.just((Object)this.getIntent(outputUri));
        return intent.flatMap((Function)new Function<Intent, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(Intent intent) throws Exception {
                intent.addFlags(1);
                return CropImage.this.startIntent.with(intent).react().map((Function)new Function<Intent, Uri>(){

                    public Uri apply(Intent intentResult) throws Exception {
                        return UCrop.getOutput((Intent)intentResult);
                    }
                }).flatMap((Function)new Function<Uri, ObservableSource<FileData>>(){

                    public ObservableSource<FileData> apply(Uri uri) throws Exception {
                        if (!outputFile.exists()) {
                            throw new FileNotFoundException(String.format("Cropped file not saved", outputFile.getAbsolutePath()));
                        }
                        FileData result = FileData.toFileDataDeleteSourceFileIfTransient(CropImage.this.fileData, outputFile, true, "image/jpeg");
                        return Observable.just((Object)result);
                    }
                });
            }
        });
    }

    private boolean isImage() {
        File file = this.fileData.getFile();
        return this.imageUtils.isImage(file);
    }

    private Intent getIntent(Uri outputUri) {
        Uri inputUri = this.getInputUri();
        UCrop.Options options = this.config.getOptions();
        if (options == null) {
            return UCrop.of((Uri)inputUri, (Uri)outputUri).getIntent(this.targetUi.getContext());
        }
        if (options instanceof Options) {
            return this.getIntentWithOptions((Options)options, outputUri);
        }
        return UCrop.of((Uri)inputUri, (Uri)outputUri).withOptions(this.config.getOptions()).getIntent(this.targetUi.getContext());
    }

    private Intent getIntentWithOptions(Options options, Uri outputUri) {
        Uri uri = Uri.fromFile((File)this.fileData.getFile());
        UCrop uCrop = UCrop.of((Uri)uri, (Uri)outputUri).withOptions((UCrop.Options)options);
        if (options.getX() != 0.0f) {
            uCrop.withAspectRatio(options.getX(), options.getY());
        }
        if (options.getWidth() != 0) {
            uCrop.withMaxResultSize(options.getWidth(), options.getHeight());
        }
        return uCrop.getIntent(this.targetUi.getContext());
    }

    private Uri getInputUri() {
        return Uri.fromFile((File)this.fileData.getFile());
    }

    private File getOutputFile() {
        String destination = this.fileData.getFile().getAbsolutePath();
        String extension = this.imageUtils.getFileExtension(destination, "jpg");
        String directory = this.config.getFileProviderDirectory();
        String outputFilename = this.imageUtils.createTimestampedFilename(CROP_APPEND, extension);
        File outputFile = this.imageUtils.getPrivateFile(directory, outputFilename);
        return outputFile;
    }
}

