/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.workers;

import com.miguelbcr.ui.rx_paparazzo2.entities.PermissionDeniedException;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.entities.UserCanceledException;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;

abstract class Worker {
    private final TargetUi targetUi;

    public Worker(TargetUi targetUi) {
        this.targetUi = targetUi;
    }

    protected <T> ObservableTransformer<T, T> applyOnError() {
        return new ObservableTransformer<T, T>(){

            public ObservableSource<T> apply(Observable<T> observable) {
                return observable.onErrorResumeNext(new Function<Throwable, ObservableSource<? extends T>>(){

                    public ObservableSource<? extends T> apply(Throwable throwable) throws Exception {
                        if (throwable instanceof UserCanceledException) {
                            return Observable.just(new Response<Object, Object>(Worker.this.targetUi.ui(), null, 0));
                        }
                        if (throwable instanceof PermissionDeniedException) {
                            return Observable.just(new Response<Object, Object>(Worker.this.targetUi.ui(), null, ((PermissionDeniedException)throwable).getCode()));
                        }
                        throw Exceptions.propagate((Throwable)throwable);
                    }
                });
            }
        };
    }
}

