/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.OriginalSize;
import io.reactivex.exceptions.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class ImageUtils {
    private final TargetUi targetUi;
    private final Config config;

    public ImageUtils(TargetUi targetUi, Config config) {
        this.targetUi = targetUi;
        this.config = config;
    }

    File getOutputFile(String extension) {
        String dirname = this.getApplicationName(this.targetUi.getContext());
        File dir = this.getDir(null, dirname);
        return this.getFile(dir, extension);
    }

    private File getFile(File dir, String extension) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy_HHmmss_SSS", new Locale("en"));
        String datetime = simpleDateFormat.format(new Date());
        File file = new File(dir.getAbsolutePath(), "IMG-" + datetime + extension);
        while (file.exists()) {
            datetime = simpleDateFormat.format(new Date());
            file = new File(dir.getAbsolutePath(), "IMG-" + datetime + extension);
        }
        return file;
    }

    File getPrivateFile(String filename) {
        File dir = new File(this.targetUi.getContext().getFilesDir(), "RxPaparazzo");
        dir.mkdirs();
        return new File(dir, filename);
    }

    private String getApplicationName(Context context) {
        int stringId = context.getApplicationInfo().labelRes;
        return context.getString(stringId);
    }

    private File getDir(String dirRoot, String dirname) {
        File storageDir = null;
        if (!this.config.useInternalStorage()) {
            storageDir = this.getPublicDir(dirRoot, dirname);
        }
        if (storageDir == null) {
            storageDir = this.getPrivateDir(dirname);
        }
        return storageDir;
    }

    private File getPublicDir(String dirRoot, String dirname) {
        File dir;
        File storageDir = null;
        if (Environment.getExternalStorageState().equals("mounted") && !(storageDir = new File(dir = dirRoot != null ? Environment.getExternalStoragePublicDirectory((String)dirRoot) : Environment.getExternalStorageDirectory(), dirname)).exists() && !storageDir.mkdirs()) {
            storageDir = null;
        }
        return storageDir;
    }

    private File getPrivateDir(String dirname) {
        File storageDir;
        File dir = this.targetUi.getContext().getFilesDir();
        File file = storageDir = TextUtils.isEmpty((CharSequence)dirname) ? dir : new File(dir, dirname);
        if (!storageDir.exists() && !storageDir.mkdirs()) {
            storageDir = null;
        }
        return storageDir;
    }

    String getFileExtension(String filepath) {
        String extension = "";
        if (filepath != null) {
            int i = filepath.lastIndexOf(46);
            extension = i > 0 ? filepath.substring(i) : "";
        }
        return TextUtils.isEmpty((CharSequence)extension) ? ".jpg" : extension;
    }

    String getFileExtension(Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            mimeType = this.targetUi.getContext().getContentResolver().getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return TextUtils.isEmpty((CharSequence)mimeType) ? this.getFileExtension(uri.getLastPathSegment()) : "." + mimeType.split("/")[1];
    }

    String scaleImage(String filePath, String filePathOutput, int[] dimens) {
        if (this.config.getSize() instanceof OriginalSize) {
            this.copyFileAndExifTags(filePath, filePathOutput, dimens);
            return filePathOutput;
        }
        Bitmap bitmap = this.handleBitmapSampling(filePath, dimens[0], dimens[1]);
        if (bitmap == null) {
            this.copyFileAndExifTags(filePath, filePathOutput, dimens);
            return filePathOutput;
        }
        this.bitmap2file(bitmap, new File(filePathOutput), this.getCompressFormat(filePathOutput));
        this.copyExifTags(filePath, filePathOutput, dimens);
        return filePathOutput;
    }

    private Bitmap.CompressFormat getCompressFormat(String filePath) {
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
        String extension = this.getFileExtension(filePath);
        if (extension.toLowerCase().contains("png")) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return compressFormat;
    }

    private void copyFileAndExifTags(String filePath, String filePathOutput, int[] dimens) {
        this.copy(new File(filePath), new File(filePathOutput));
        this.copyExifTags(filePath, filePathOutput, dimens);
    }

    public void copy(InputStream in, File dst) {
        FileOutputStream out = null;
        try {
            int length;
            out = new FileOutputStream(dst);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void copy(File src, File dst) {
        try {
            FileInputStream in = new FileInputStream(src);
            this.copy(in, dst);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void bitmap2file(Bitmap bitmap, File file, Bitmap.CompressFormat compressFormat) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(compressFormat, 90, (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copyExifTags(String srcFilePath, String dstFilePath, int[] dimens) {
        if (this.getCompressFormat(dstFilePath) == Bitmap.CompressFormat.JPEG) {
            try {
                ExifInterface exifSource = new ExifInterface(srcFilePath);
                ExifInterface exifDest = new ExifInterface(dstFilePath);
                for (String attribute : this.getExifTags()) {
                    String tagValue = exifSource.getAttribute(attribute);
                    if (TextUtils.isEmpty((CharSequence)tagValue)) continue;
                    exifDest.setAttribute(attribute, tagValue);
                }
                exifDest.setAttribute("ImageWidth", String.valueOf(dimens[0]));
                exifDest.setAttribute("ImageLength", String.valueOf(dimens[1]));
                exifDest.saveAttributes();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getExifTags() {
        return new String[]{"DateTime", "ExposureTime", "Flash", "FocalLength", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSProcessingMethod", "WhiteBalance", "Orientation", "Make", "GPSTimeStamp", "Model", "ISOSpeedRatings", "SubSecTime", "DateTimeDigitized", "SubSecTimeDigitized", "SubSecTimeOriginal", "MeteringMode", "FNumber"};
    }

    private Bitmap handleBitmapSampling(String filePath, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int n = options.inSampleSize = maxWidth <= 0 || maxHeight <= 0 ? 1 : this.calculateInSampleSize(options, maxWidth, maxHeight);
        if (options.inSampleSize == 1) {
            return null;
        }
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int inSampleSize = 1;
        int[] dimensPortrait = this.getDimensionsPortrait(options.outWidth, options.outHeight);
        int[] maxDimensPortrait = this.getDimensionsPortrait(maxWidth, maxHeight);
        float width = dimensPortrait[0];
        float height = dimensPortrait[1];
        float newMaxWidth = maxDimensPortrait[0];
        float newMaxHeight = maxDimensPortrait[1];
        if (height > newMaxHeight || width > newMaxWidth) {
            int widthRatio;
            int heightRatio = Math.round(height / newMaxHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round(width / newMaxWidth)) ? heightRatio : widthRatio;
            float totalPixels = width * height;
            float totalReqPixels = newMaxWidth * newMaxHeight * 2.0f;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixels) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    private int[] getDimensionsPortrait(int width, int height) {
        if (width < height) {
            return new int[]{width, height};
        }
        return new int[]{height, width};
    }
}

