/*
 * Decompiled with CFR 0.152.
 */
package com.mifmif.common.regex;

import com.mifmif.common.regex.TransitionLevel;
import com.mifmif.common.regex.util.Iterator;
import dk.brics.automaton.State;
import java.util.Stack;

public class GenerexIterator
implements Iterator {
    Stack<TransitionLevel> transitionsPath = new Stack();
    String currentValue = "";

    public GenerexIterator(State initialState) {
        TransitionLevel initialLevel = new TransitionLevel(initialState);
        this.transitionsPath.add(initialLevel);
    }

    public boolean hasNext() {
        return !this.transitionsPath.isEmpty();
    }

    public String next() {
        while (!this.transitionsPath.isEmpty()) {
            TransitionLevel currentLevel = this.transitionsPath.peek();
            State state = currentLevel.getState();
            if (!state.isAccept()) {
                this.addNextTransitionLevel(currentLevel);
                continue;
            }
            this.currentValue = "";
            for (int i = 0; i < this.transitionsPath.size() - 1; ++i) {
                TransitionLevel transitionLevel = (TransitionLevel)this.transitionsPath.get(i);
                this.currentValue = this.currentValue + transitionLevel.getCurrentChar();
            }
            this.jumpToNextPath();
            break;
        }
        return this.currentValue;
    }

    private void jumpToNextPath() {
        while (!this.transitionsPath.isEmpty()) {
            char currChar;
            TransitionLevel currentLevel = this.transitionsPath.peek();
            if (currentLevel.hasNextTransitionLevel()) {
                TransitionLevel nextTransitionLevel = currentLevel.nextTransitionLevel();
                this.transitionsPath.push(nextTransitionLevel);
                break;
            }
            if (currentLevel.hasCharacterTransition() && (currChar = currentLevel.getCurrentChar()) < currentLevel.getMaxCharInCurrentTransition()) {
                currChar = (char)(currChar + '\u0001');
                currentLevel.setCurrentChar(currChar);
                break;
            }
            if (currentLevel.jumpToNextTransition()) break;
            this.transitionsPath.pop();
        }
    }

    private void addNextTransitionLevel(TransitionLevel currentLevel) {
        State nextState = currentLevel.getCurrentTransition().getDest();
        TransitionLevel nextLevel = new TransitionLevel(nextState);
        this.transitionsPath.add(nextLevel);
    }
}

