/*
 * Decompiled with CFR 0.152.
 */
package com.mynameismidori.currencypicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.mynameismidori.currencypicker.ExtendedCurrency;
import com.mynameismidori.currencypicker.R;
import java.util.List;

public class CurrencyListAdapter
extends BaseAdapter {
    private Context mContext;
    List<ExtendedCurrency> currencies;
    LayoutInflater inflater;

    public CurrencyListAdapter(Context context, List<ExtendedCurrency> currencies) {
        this.mContext = context;
        this.currencies = currencies;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.currencies.size();
    }

    public Object getItem(int arg0) {
        return null;
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View view, ViewGroup parent) {
        ExtendedCurrency currency = this.currencies.get(position);
        if (view == null) {
            view = this.inflater.inflate(R.layout.row, null);
        }
        Cell cell = Cell.from(view);
        cell.textView.setText((CharSequence)currency.getName());
        currency.loadFlagByCode(this.mContext);
        if (currency.getFlag() != -1) {
            cell.imageView.setImageResource(currency.getFlag());
        }
        return view;
    }

    static class Cell {
        public TextView textView;
        public ImageView imageView;

        Cell() {
        }

        static Cell from(View view) {
            if (view == null) {
                return null;
            }
            if (view.getTag() == null) {
                Cell cell = new Cell();
                cell.textView = (TextView)view.findViewById(R.id.row_title);
                cell.imageView = (ImageView)view.findViewById(R.id.row_icon);
                view.setTag((Object)cell);
                return cell;
            }
            return (Cell)view.getTag();
        }
    }
}

