/*
 * Decompiled with CFR 0.152.
 */
package com.mynameismidori.currencypicker;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.preference.ListPreference;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mynameismidori.currencypicker.CurrencyListAdapter;
import com.mynameismidori.currencypicker.ExtendedCurrency;
import com.mynameismidori.currencypicker.R;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CurrencyPreference
extends ListPreference
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private EditText searchEditText;
    private ListView currencyListView;
    private CharSequence[] currencyName;
    private CharSequence[] currencyCode;
    private CurrencyListAdapter adapter;
    private int currentIndex = 0;
    private List<ExtendedCurrency> currenciesList = new ArrayList<ExtendedCurrency>();
    private List<ExtendedCurrency> selectedCurrenciesList = new ArrayList<ExtendedCurrency>();
    private Resources resources;
    private String selectedCurrencyCode;
    private String defaultCurrencyCode;
    SharedPreferences preferences;
    SharedPreferences.Editor editor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrencyPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.setCurrenciesList(ExtendedCurrency.getAllCurrencies());
        this.editor = this.preferences.edit();
        this.setSummary(this.preferences.getString(this.getKey(), this.getValue()));
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.attrs_currency, 0, 0);
        try {
            this.defaultCurrencyCode = a.getString(R.styleable.attrs_currency_currencyCode);
        }
        finally {
            a.recycle();
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (key.equals("selectedCurrency")) {
            this.setSummary(this.getValue());
        }
        if (key.equals("selectedCurrencies")) {
            this.setCurrenciesList(this.preferences.getStringSet("selectedCurrencies", new HashSet()));
        }
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.currency_picker, null);
        this.searchEditText = (EditText)view.findViewById(R.id.currency_code_picker_search);
        this.currencyListView = (ListView)view.findViewById(R.id.currency_code_picker_listview);
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                CurrencyPreference.this.search(s.toString());
            }
        });
        LinearLayout linearLayout = (LinearLayout)view.findViewById(R.id.linear_layout);
        ListView currencyListView = (ListView)view.findViewById(R.id.currency_code_picker_listview);
        this.selectedCurrenciesList = new ArrayList<ExtendedCurrency>(this.currenciesList.size());
        this.selectedCurrenciesList.addAll(this.currenciesList);
        this.adapter = new CurrencyListAdapter(this.getContext(), this.selectedCurrenciesList);
        currencyListView.setAdapter((ListAdapter)this.adapter);
        currencyListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ExtendedCurrency currency = (ExtendedCurrency)CurrencyPreference.this.selectedCurrenciesList.get(position);
                CurrencyPreference.this.setValue(currency.getCode());
                CurrencyPreference.this.setSummary(currency.getCode());
                CurrencyPreference.this.editor.putString(CurrencyPreference.this.getKey(), currency.getCode());
                CurrencyPreference.this.editor.commit();
                CurrencyPreference.this.getDialog().dismiss();
            }
        });
        builder.setView(view);
        builder.setNegativeButton((CharSequence)"Cancel", null);
        builder.setPositiveButton(null, null);
        this.currencyCode = this.getEntries();
        this.currencyName = this.getEntryValues();
        if (this.currencyName == null || this.currencyCode == null || this.currencyCode.length != this.currencyName.length) {
            throw new IllegalStateException("Preference requires an entries array and an entryValues array which are both the same length");
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    private void search(String text) {
        this.selectedCurrenciesList.clear();
        for (ExtendedCurrency currency : this.currenciesList) {
            if (!currency.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase())) continue;
            this.selectedCurrenciesList.add(currency);
        }
        this.adapter.notifyDataSetChanged();
    }

    public void setCurrenciesList(List<ExtendedCurrency> newCurrencies) {
        this.currenciesList.clear();
        this.currenciesList.addAll(newCurrencies);
    }

    public void setCurrenciesList(Set<String> savedCurrencies) {
        this.currenciesList.clear();
        for (String code : savedCurrencies) {
            this.currenciesList.add(ExtendedCurrency.getCurrencyByISO(code));
        }
    }
}

