/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal;

import com.github.microwww.redis.ChannelContext;
import com.github.microwww.redis.RedisServer;
import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.PubSub;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.protocal.RedisOutputProtocol;
import com.github.microwww.redis.protocal.RequestSession;
import com.github.microwww.redis.util.Assert;
import com.github.microwww.redis.util.IoRunnable;
import java.util.Arrays;

public class RedisRequest {
    private static final Logger log = LogFactory.getLogger(RedisRequest.class);
    private final ChannelContext context;
    private final String command;
    private final RequestParams[] params;
    private final RedisServer server;
    private IoRunnable next = () -> {
        log.debug("Flush {} outputStream {}", this.getCommand(), this.getContext().getRemoteHost());
        this.getOutputProtocol().flush();
    };

    public static RedisRequest warp(RedisRequest request, String cmd, RequestParams[] params) {
        return new RedisRequest(request.getServer(), request.getContext(), cmd, params);
    }

    public RedisRequest(RedisServer server, ChannelContext context, String command, RequestParams[] params) {
        this.server = server;
        this.context = context;
        this.command = command;
        this.params = params;
    }

    public RedisRequest(RedisServer server, ChannelContext context, RequestParams[] request) {
        this(server, context, request[0].isNotNull().getByteArray2string(), new RequestParams[request.length - 1]);
        System.arraycopy(request, 1, this.params, 0, this.params.length);
    }

    public ChannelContext getContext() {
        return this.context;
    }

    public String getCommand() {
        return this.command;
    }

    public RequestParams[] getParams() {
        return Arrays.copyOf(this.params, this.params.length);
    }

    public RedisOutputProtocol getOutputProtocol() {
        return this.context.getProtocol();
    }

    public RedisDatabase getDatabase() {
        int index = this.context.getSessions().getDatabase();
        return this.server.getSchema().getRedisDatabases(index);
    }

    public PubSub getPubSub() {
        return this.server.getSchema().getPubSub();
    }

    public void expectArgumentsCount(int expect) {
        int count = this.getParams().length;
        Assert.isTrue(count == expect, String.format("The number of arguments is not as expected, expect: %d, BUT: %d", expect, count));
    }

    public void expectArgumentsCountBigger(int expect) {
        int count = this.getParams().length;
        Assert.isTrue(count > expect, String.format("The number of arguments is not as expected, expect: > %d, BUT: = %d", expect, count));
    }

    public void expectArgumentsCountGE(int expect) {
        int count = this.getParams().length;
        Assert.isTrue(count >= expect, String.format("The number of arguments is not as expected, expect: >= %d, BUT: = %d", expect, count));
    }

    public void expectArgumentsCountLitter(int expect) {
        int count = this.getParams().length;
        Assert.isTrue(count < expect, String.format("The number of arguments is not as expected, expect: < %d, BUT: = %d", expect, count));
    }

    public void expectArgumentsCountLE(int expect) {
        int count = this.getParams().length;
        Assert.isTrue(count <= expect, String.format("The number of arguments is not as expected, expect: <= %d, BUT: = %d", expect, count));
    }

    public RedisServer getServer() {
        return this.server;
    }

    public IoRunnable getNext() {
        return this.next;
    }

    public void setNext(IoRunnable next) {
        this.next = next;
    }

    public RequestSession getSessions() {
        return this.context.getSessions();
    }
}

