/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis;

import com.github.microwww.redis.ChannelContext;
import com.github.microwww.redis.ChannelSessionHandler;
import com.github.microwww.redis.exception.Run;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.util.Assert;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class SelectSockets
implements Closeable {
    private static final Logger logger = LogFactory.getLogger(SelectSockets.class);
    private ServerSocketChannel serverChannel;
    protected ServerSocket serverSocket;
    protected Selector selector;
    private AtomicBoolean close = new AtomicBoolean();
    private Set<ChannelContext> clients = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Function<ChannelContext, ChannelSessionHandler> factory;

    public SelectSockets(Function<ChannelContext, ChannelSessionHandler> factory) {
        Assert.isTrue(factory != null, "Not null");
        this.factory = factory;
    }

    public SelectSockets bind(String host, int port) throws IOException {
        this.serverChannel = ServerSocketChannel.open();
        this.serverSocket = this.serverChannel.socket();
        this.selector = Selector.open();
        this.serverSocket.bind(new InetSocketAddress(host, port));
        this.serverChannel.configureBlocking(false);
        this.serverChannel.register(this.selector, 16);
        return this;
    }

    public void sync() {
        Thread.currentThread().setName("SELECT-IO");
        while (!this.close.get()) {
            Run.ignoreException(logger, () -> this.tryRun());
        }
        Run.ignoreException(logger, this::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRun() throws IOException {
        int n = this.selector.select();
        if (n <= 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            try {
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    ServerSocketChannel server = (ServerSocketChannel)key.channel();
                    SocketChannel channel = server.accept();
                    ChannelContext ctx = this.registerChannel(channel, 1);
                    ChannelSessionHandler channelHandler = this.factory.apply(ctx);
                    this.clients.add(ctx);
                    ctx.addCloseListener(this.clients::remove);
                    ctx.setChannelHandler(channelHandler);
                    try {
                        channelHandler.registerHandler(ctx);
                    }
                    catch (Exception ex) {
                        logger.warn("Handler error, invoke Handler.exception", ex);
                        channelHandler.exception(ctx, ex);
                    }
                }
                if (!key.isReadable()) continue;
                ChannelContext ctx = (ChannelContext)key.attachment();
                ctx.assertChannel(key.channel());
                ByteBuffer read = ctx.readChannel();
                ChannelSessionHandler channelHandler = ctx.getChannelHandler();
                try {
                    channelHandler.readableHandler(ctx, read);
                    ctx.readOver(read);
                }
                catch (Exception ex) {
                    logger.warn("Handler error, invoke Handler.exception", ex);
                    channelHandler.exception(ctx, ex);
                }
            }
            catch (Exception ex) {
                ChannelContext context = (ChannelContext)key.attachment();
                if (context != null) {
                    logger.info("IOException: {}, and Go to close client: {}", ex.getMessage(), context.getRemoteHost());
                    try {
                        context.getChannelHandler().close(context);
                    }
                    catch (Throwable throwable) {
                        context.closeChannel();
                        Assert.isTrue(!key.channel().isOpen(), "Must close channel");
                        logger.info("Remote channel {} , is closed", context.getRemoteHost());
                        throw throwable;
                    }
                    context.closeChannel();
                    Assert.isTrue(!key.channel().isOpen(), "Must close channel");
                    logger.info("Remote channel {} , is closed", context.getRemoteHost());
                    continue;
                }
                this.closeChannel(key);
            }
            finally {
                it.remove();
            }
        }
    }

    private ChannelContext registerChannel(SelectableChannel channel, int ops) throws IOException {
        if (channel == null) {
            return null;
        }
        channel.configureBlocking(false);
        ChannelContext ctx = new ChannelContext((SocketChannel)channel);
        channel.register(this.selector, ops, ctx);
        return ctx;
    }

    private void closeChannel(SelectionKey key) throws IOException {
        SelectableChannel channel = key.channel();
        if (channel instanceof SocketChannel) {
            this.closeChannel((SocketChannel)channel);
        }
        key.cancel();
    }

    public void closeChannel(SocketChannel channel) throws IOException {
        try {
            InetSocketAddress add = (InetSocketAddress)channel.getRemoteAddress();
            logger.info("Remote client {}:{} is closed", add.getHostName(), add.getPort());
        }
        catch (Exception e) {
            logger.info("Remote channel {} , is closed", channel);
        }
        finally {
            channel.close();
        }
    }

    public ServerSocket getServerSocket() {
        if (this.serverChannel == null) {
            Thread.yield();
        }
        return this.serverSocket;
    }

    public void stop() {
        if (this.close.get()) {
            return;
        }
        this.close.set(true);
    }

    public boolean isClose() {
        return this.close.get();
    }

    @Override
    public void close() throws IOException {
        this.close.set(true);
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        finally {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
    }

    public Set<ChannelContext> getClients() {
        return Collections.unmodifiableSet(this.clients);
    }
}

