/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;

public class AudioVideoUtils {
    public static int getFitBitRate(int wxh) {
        if (wxh <= 230400) {
            return 1024000;
        }
        if (wxh <= 307200) {
            return 0x177000;
        }
        if (wxh <= 384000) {
            return 1843200;
        }
        if (wxh <= 522240) {
            return 0x200000;
        }
        if (wxh <= 921600) {
            return 0x280000;
        }
        if (wxh <= 2088960) {
            return 0x300000;
        }
        return 3584000;
    }

    public static int selectVideoTrack(MediaExtractor extractor) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!mime.startsWith("video/")) continue;
            return i;
        }
        return -1;
    }

    public static int selectAudioTrack(MediaExtractor extractor) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!mime.startsWith("audio/")) continue;
            return i;
        }
        return -1;
    }

    public static long getDuration(String url) {
        try {
            MediaExtractor mediaExtractor = new MediaExtractor();
            mediaExtractor.setDataSource(url);
            int videoExt = AudioVideoUtils.selectVideoTrack(mediaExtractor);
            MediaFormat mediaFormat = mediaExtractor.getTrackFormat(videoExt);
            long res = mediaFormat.containsKey("durationUs") ? mediaFormat.getLong("durationUs") : 0L;
            mediaExtractor.release();
            return res;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static int getVideoWidth(String videoPath) {
        MediaMetadataRetriever retr = new MediaMetadataRetriever();
        retr.setDataSource(videoPath);
        String width = retr.extractMetadata(18);
        String height = retr.extractMetadata(19);
        String rotation = retr.extractMetadata(24);
        if ("90".equals(rotation) || "270".equals(rotation)) {
            width = height;
        }
        retr.release();
        return Integer.parseInt(width);
    }

    public static int getVideoHeight(String videoPath) {
        MediaMetadataRetriever retr = new MediaMetadataRetriever();
        retr.setDataSource(videoPath);
        String width = retr.extractMetadata(18);
        String height = retr.extractMetadata(19);
        String rotation = retr.extractMetadata(24);
        if ("90".equals(rotation) || "270".equals(rotation)) {
            height = width;
        }
        retr.release();
        return Integer.parseInt(height);
    }

    public static int getVideoRotation(String videoPath) {
        MediaMetadataRetriever retr = new MediaMetadataRetriever();
        retr.setDataSource(videoPath);
        String rotation = retr.extractMetadata(24);
        retr.release();
        return Integer.parseInt(rotation);
    }

    public static int getVideoDuration(String videoPath) {
        MediaMetadataRetriever retr = new MediaMetadataRetriever();
        retr.setDataSource(videoPath);
        String rotation = retr.extractMetadata(9);
        retr.release();
        return Integer.parseInt(rotation) / 1000;
    }

    public static boolean isHorizontalVideo(String videoPath) {
        return AudioVideoUtils.getVideoWidth(videoPath) >= AudioVideoUtils.getVideoHeight(videoPath);
    }
}

