/*
 * Decompiled with CFR 0.152.
 */
package com.github.michaeboyles.dgs;

import com.netflix.graphql.dgs.codegen.CodeGen;
import com.netflix.graphql.dgs.codegen.CodeGenConfig;
import com.netflix.graphql.dgs.codegen.Language;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}/../resources/schema")
    private File[] schemaPaths = new File[0];
    @Parameter(required=true)
    private String packageName;
    @Parameter(defaultValue="client")
    private String subPackageNameClient;
    @Parameter(defaultValue="datafetchers")
    private String subPackageNameDatafetchers;
    @Parameter(defaultValue="types")
    private String subPackageNameTypes;
    @Parameter
    private String language = this.hasKotlinPluginWrapperClass() ? "KOTLIN" : "JAVA";
    @Parameter
    private Map<String, String> typeMapping = new HashMap<String, String>();
    @Parameter
    private boolean generateBoxedTypes = false;
    @Parameter
    private boolean generateClient = false;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations/")
    private File outputDir;
    @Parameter(defaultValue="${project.build.directory}/generated-examples")
    private File examplesOutputDir;
    @Parameter
    private List<String> includeQueries = new ArrayList<String>();
    @Parameter
    private List<String> includeMutations = new ArrayList<String>();
    @Parameter
    private List<String> includeSubscriptions = new ArrayList<String>();
    @Parameter
    private boolean skipEntityQueries = false;
    @Parameter
    private boolean shortProjectionNames = false;
    @Parameter
    private boolean generateDataTypes = true;
    @Parameter
    private int maxProjectionDepth = 10;
    @Parameter
    private boolean omitNullInputFields = false;
    @Parameter
    private boolean generateInterfaces = false;
    @Parameter
    private boolean kotlinAllFieldsOptional = false;
    @Parameter
    private boolean snakeCaseConstantNames = false;
    @Parameter
    private boolean generateInterfaceSetters = true;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() {
        Set schemaPaths = Arrays.stream(this.schemaPaths).map(this::getCanonicalFile).collect(Collectors.toSet());
        for (File schemaPath : schemaPaths) {
            if (schemaPath.exists()) continue;
            this.getLog().warn((CharSequence)("Schema location " + schemaPath + " does not exist"));
        }
        CodeGenConfig config = new CodeGenConfig(Collections.emptySet(), schemaPaths, this.getCanonicalFile(this.outputDir).toPath(), this.getCanonicalFile(this.examplesOutputDir).toPath(), true, this.packageName, this.subPackageNameClient, this.subPackageNameDatafetchers, this.subPackageNameTypes, Language.valueOf((String)this.language.toUpperCase()), this.generateBoxedTypes, this.generateClient, this.generateInterfaces, this.typeMapping, new HashSet<String>(this.includeQueries), new HashSet<String>(this.includeMutations), new HashSet<String>(this.includeSubscriptions), this.skipEntityQueries, this.shortProjectionNames, this.generateDataTypes, this.omitNullInputFields, this.maxProjectionDepth, this.kotlinAllFieldsOptional, this.snakeCaseConstantNames, this.generateInterfaceSetters);
        this.getLog().info((CharSequence)("Codegen config: " + config));
        new CodeGen(config).generate();
        this.project.addCompileSourceRoot(this.getCanonicalFile(this.outputDir).getAbsolutePath());
    }

    private File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasKotlinPluginWrapperClass() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

