/*
 * Decompiled with CFR 0.152.
 */
package com.gamemalt.indicatordots;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.LinearLayout;
import com.gamemalt.indicatordots.AnimUtils;
import com.gamemalt.indicatordots.CircleView;
import com.gamemalt.indicatordots.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Stack;

public class IndicatorDots
extends LinearLayout {
    private Stack<View> stack = new Stack();
    private static final int DEFAULT_PIN_LENGTH = 0;
    private static final int DEFAULT_ANIMATION_DURATION = 100;
    private int mDotDiameter;
    private int mDotSpacing;
    private int mDotColor;
    private int mInitialPinLength;
    private int mIndicatorType;

    public IndicatorDots(Context context) {
        this(context, null);
    }

    public IndicatorDots(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndicatorDots(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IndicatorDots);
        try {
            this.mDotDiameter = (int)typedArray.getDimension(R.styleable.IndicatorDots_dotDiameter, this.getResources().getDimension(R.dimen.dot_diameter));
            this.mDotSpacing = (int)typedArray.getDimension(R.styleable.IndicatorDots_dotSpacing, this.getResources().getDimension(R.dimen.dot_spacing));
            this.mInitialPinLength = typedArray.getInt(R.styleable.IndicatorDots_pinLength, 0);
            this.mIndicatorType = typedArray.getInt(R.styleable.IndicatorDots_indicatorType, 2);
            this.mDotColor = typedArray.getColor(R.styleable.IndicatorDots_dotColor, this.getResources().getColor(R.color.dots_defaultColor));
        }
        finally {
            typedArray.recycle();
        }
        this.initView(context);
    }

    public void setDotColor(int mDotColor) {
        this.mDotColor = mDotColor;
    }

    private void initView(Context context) {
        if (this.mInitialPinLength != 0) {
            for (int i = 0; i < this.mInitialPinLength; ++i) {
                CircleView circleView = this.getOneDot();
                this.addView(circleView);
                this.stack.push(circleView);
            }
        }
        if (this.mIndicatorType == 2) {
            LayoutTransition layoutTransition = new LayoutTransition();
            layoutTransition.setDuration(100L);
            layoutTransition.setStartDelay(2, 0L);
            layoutTransition.setStartDelay(1, 0L);
            this.setLayoutTransition(layoutTransition);
        }
    }

    private CircleView getOneDot() {
        CircleView circleView1 = new CircleView(this.getContext());
        circleView1.setDotColor(this.mDotColor);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mDotDiameter, this.mDotDiameter);
        params.setMargins(this.mDotSpacing, 0, this.mDotSpacing, 0);
        circleView1.setLayoutParams((ViewGroup.LayoutParams)params);
        return circleView1;
    }

    public void incrementDot() {
        final CircleView circleView1 = this.getOneDot();
        this.addView(circleView1);
        this.stack.push(circleView1);
        if (this.mIndicatorType == 2) {
            circleView1.post(new Runnable(){

                @Override
                public void run() {
                    circleView1.startAnimation((Animation)AnimUtils.appearingAnim(350, 4.5f));
                }
            });
        }
    }

    public void decrementDot() {
        if (!this.stack.isEmpty()) {
            final View v = this.stack.pop();
            final ScaleAnimation scaleAnimation = AnimUtils.disAppearingAnim(130);
            scaleAnimation.setFillEnabled(true);
            scaleAnimation.setFillAfter(true);
            scaleAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    v.post(new Runnable(){

                        @Override
                        public void run() {
                            IndicatorDots.this.removeView(v);
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            v.post(new Runnable(){

                @Override
                public void run() {
                    v.startAnimation((Animation)scaleAnimation);
                }
            });
        }
    }

    public void setWidth(int widthPx) {
        this.getLayoutParams().width = widthPx;
    }

    public void resetDots() {
        this.removeAllViews();
    }

    public void resetDotsWithAnim() {
        while (!this.stack.isEmpty()) {
            final View view = this.stack.pop();
            if (view == null) {
                return;
            }
            ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, 0.5f, 1, 0.5f);
            scaleAnimation.setFillEnabled(true);
            scaleAnimation.setFillAfter(true);
            scaleAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    view.post(new Runnable(){

                        @Override
                        public void run() {
                            IndicatorDots.this.removeView(view);
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            scaleAnimation.setDuration(130L);
            view.startAnimation((Animation)scaleAnimation);
        }
    }

    public int getInitialPinLength() {
        return this.mInitialPinLength;
    }

    public void setInitialPinLength(int pinLength) {
        this.mInitialPinLength = pinLength;
    }

    public int getIndicatorType() {
        return this.mIndicatorType;
    }

    public void setIndicatorType(int type) {
        this.mIndicatorType = type;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndicatorType {
        public static final int FILL = 1;
        public static final int FILL_WITH_ANIMATION = 2;
    }
}

