/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.bosh.EceEventListener;
import org.jivesoftware.smack.bosh.EceStatusEvent;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Message;

public class EceEventDispatcher {
    private static final StanzaFilter ECE_EVENT_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.HEADLINE, MessageWithBodiesFilter.INSTANCE, FromTypeFilter.DOMAIN_BARE_JID});
    private List<EceEventListener> listeners = new ArrayList<EceEventListener>();

    public EceEventDispatcher(AbstractXMPPConnection connection) {
        connection.addAsyncStanzaListener(packet -> {
            Message msg = (Message)packet;
            EceStatusEvent status = EceStatusEvent.valueOf(msg.getBody());
            if (status != null) {
                this.emitEvent(status);
            }
        }, ECE_EVENT_FILTER);
    }

    public void addListener(EceEventListener listener) {
        this.listeners.add(listener);
    }

    public void emitEvent(EceStatusEvent event) {
        this.listeners.stream().forEach(l -> l.newEvent(event));
    }
}

