/*
 * Decompiled with CFR 0.152.
 */
package com.mhadikz.toaster;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.mhadikz.toaster.R;
import com.mhadikz.toaster.Utils;

public class Toaster
extends Toast {
    private final String title;
    private final String description;
    private final int duration;
    private final Status status;
    private final Context context;

    private Toaster(Builder builder) {
        super(builder.context);
        this.title = builder.title;
        this.description = builder.description;
        this.duration = builder.duration;
        this.status = builder.status;
        this.context = builder.context;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDuration() {
        return this.duration;
    }

    public Status getStatus() {
        return this.status;
    }

    public Context getContext() {
        return this.context;
    }

    public static enum Status {
        INFO,
        SUCCESS,
        WARNING,
        ERROR;

    }

    public static class Builder {
        private String title;
        private String description;
        private int duration;
        private Status status;
        private Context context;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        private void generateMessage() {
            Toast toast = new Toast(this.context);
            Utils utils = new Utils(this.status, this.context);
            View toastLayout = LayoutInflater.from((Context)this.context).inflate(R.layout.toaster_layout, null, false);
            TextView title = (TextView)toastLayout.findViewById(R.id.title);
            TextView description = (TextView)toastLayout.findViewById(R.id.description);
            ImageView icon = (ImageView)toastLayout.findViewById(R.id.icon);
            RelativeLayout toastContainer = (RelativeLayout)toastLayout.findViewById(R.id.toast_container);
            toastContainer.setBackground(utils.setStatusBackground());
            icon.setImageDrawable(utils.setStatusIcon());
            title.setText((CharSequence)this.title);
            description.setText((CharSequence)this.description);
            toast.setView(toastLayout);
            toast.setDuration(this.duration);
            toast.show();
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDuration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Toaster show() {
            this.generateMessage();
            return new Toaster(this);
        }
    }
}

