/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.utils;

import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;

public class LightUtils {
    public static LightsInfo getLightsInfo(LightsInfo info, Environment environment) {
        SpotLightsAttribute sla;
        PointLightsAttribute pla;
        info.reset();
        DirectionalLightsAttribute dla = (DirectionalLightsAttribute)environment.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            info.dirLights = dla.lights.size;
        }
        if ((pla = (PointLightsAttribute)environment.get(PointLightsAttribute.class, PointLightsAttribute.Type)) != null) {
            info.pointLights = pla.lights.size;
        }
        if ((sla = (SpotLightsAttribute)environment.get(SpotLightsAttribute.class, SpotLightsAttribute.Type)) != null) {
            info.spotLights = sla.lights.size;
        }
        return info;
    }

    public static LightsInfo getLightsInfo(LightsInfo info, Iterable<BaseLight> lights) {
        info.reset();
        for (BaseLight light : lights) {
            if (light instanceof DirectionalLight) {
                ++info.dirLights;
                continue;
            }
            if (light instanceof PointLight) {
                ++info.pointLights;
                continue;
            }
            if (light instanceof SpotLight) {
                ++info.spotLights;
                continue;
            }
            ++info.miscLights;
        }
        return info;
    }

    public static class LightsInfo {
        public int dirLights = 0;
        public int pointLights = 0;
        public int spotLights = 0;
        public int miscLights = 0;

        public void reset() {
            this.dirLights = 0;
            this.pointLights = 0;
            this.spotLights = 0;
            this.miscLights = 0;
        }
    }
}

