/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;

public class FacedMultiCubemapData
implements CubemapData {
    protected final TextureData[] data;
    private int levels;

    public FacedMultiCubemapData(FileHandle[] files, int levels) {
        this.levels = levels;
        this.data = new TextureData[6 * levels];
        for (int level = 0; level < levels; ++level) {
            for (int face = 0; face < 6; ++face) {
                int index = level * 6 + face;
                FileHandle file = files[index];
                this.data[index] = new PixmapTextureData(new Pixmap(file), null, false, true);
            }
        }
    }

    public FacedMultiCubemapData(Pixmap[] pixmaps, int levels) {
        this.levels = levels;
        this.data = new TextureData[6 * levels];
        for (int level = 0; level < levels; ++level) {
            for (int face = 0; face < 6; ++face) {
                int index = level * 6 + face;
                Pixmap pixmap = pixmaps[index];
                this.data[index] = new PixmapTextureData(pixmap, null, false, true);
            }
        }
    }

    public boolean isManaged() {
        for (TextureData data : this.data) {
            if (data.isManaged()) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) continue;
            return false;
        }
        return true;
    }

    public TextureData getTextureData(Cubemap.CubemapSide side) {
        return this.data[side.index];
    }

    public int getWidth() {
        int tmp;
        int width = 0;
        if (this.data[Cubemap.CubemapSide.PositiveZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.PositiveZ.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[Cubemap.CubemapSide.NegativeZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.NegativeZ.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[Cubemap.CubemapSide.PositiveY.index] != null && (tmp = this.data[Cubemap.CubemapSide.PositiveY.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[Cubemap.CubemapSide.NegativeY.index] != null && (tmp = this.data[Cubemap.CubemapSide.NegativeY.index].getWidth()) > width) {
            width = tmp;
        }
        return width;
    }

    public int getHeight() {
        int tmp;
        int height = 0;
        if (this.data[Cubemap.CubemapSide.PositiveZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.PositiveZ.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[Cubemap.CubemapSide.NegativeZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.NegativeZ.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[Cubemap.CubemapSide.PositiveX.index] != null && (tmp = this.data[Cubemap.CubemapSide.PositiveX.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[Cubemap.CubemapSide.NegativeX.index] != null && (tmp = this.data[Cubemap.CubemapSide.NegativeX.index].getHeight()) > height) {
            height = tmp;
        }
        return height;
    }

    public boolean isPrepared() {
        return false;
    }

    public void prepare() {
        if (!this.isComplete()) {
            throw new GdxRuntimeException("You need to complete your cubemap data before using it");
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].isPrepared()) continue;
            this.data[i].prepare();
        }
    }

    public void consumeCubemapData() {
        for (int level = 0; level < this.levels; ++level) {
            for (int i = 0; i < 6; ++i) {
                int index = level * 6 + i;
                if (this.data[index].getType() == TextureData.TextureDataType.Custom) {
                    this.data[index].consumeCustomData(34069 + i);
                    continue;
                }
                Pixmap pixmap = this.data[index].consumePixmap();
                boolean disposePixmap = this.data[index].disposePixmap();
                if (this.data[index].getFormat() != pixmap.getFormat()) {
                    Pixmap tmp = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), this.data[index].getFormat());
                    tmp.setBlending(Pixmap.Blending.None);
                    tmp.drawPixmap(pixmap, 0, 0, 0, 0, pixmap.getWidth(), pixmap.getHeight());
                    if (this.data[index].disposePixmap()) {
                        pixmap.dispose();
                    }
                    pixmap = tmp;
                    disposePixmap = true;
                }
                Gdx.gl.glPixelStorei(3317, 1);
                Gdx.gl.glTexImage2D(34069 + i, level, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), (Buffer)pixmap.getPixels());
                if (!disposePixmap) continue;
                pixmap.dispose();
            }
        }
    }
}

